<!doctype html>
<html lang="bn">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(env('APP_NAME')); ?></title>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layer-v3.5.1/dist/theme/default/layer.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html, body {
            height: 100%;
            width: 100%;
            background: var(--primary-bg);
        }

        body {
            background: var(--primary-bg);
            color: var(--text-primary);
            font-family: 'Noto Sans Bengali', sans-serif;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        #app {
            flex: 1;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }

        /* Header Styles */
        .app-header {
            background: var(--secondary-bg);
            padding: 15px 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .header-logo {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            border: 2px solid var(--accent-gold);
        }

        .app-name {
            font-size: 18px;
            font-weight: 700;
            color: var(--accent-gold);
        }

        .language-btn {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            padding: 8px 16px;
            border: none;
            border-radius: 20px;
            font-weight: 600;
            font-size: 14px;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 2px 8px rgba(255, 215, 0, 0.3);
        }

        .language-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-1px);
        }

        /* Main Content Styles */
        .main-content {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            width: 100%;
        }

        .login-container {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            padding: 30px 25px;
            width: 100%;
            max-width: 400px;
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            transition: var(--transition);
        }

        .login-container:hover {
            box-shadow: 0 8px 25px rgba(255, 215, 0, 0.15);
        }

        .welcome-section {
            text-align: center;
            margin-bottom: 30px;
        }

        .app-logo {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            border: 3px solid var(--accent-gold);
            margin: 0 auto 20px;
            padding: 5px;
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
        }

        .welcome-title {
            font-size: 28px;
            font-weight: 700;
            color: var(--accent-gold);
            margin-bottom: 8px;
            text-shadow: 0 2px 4px rgba(255, 215, 0, 0.3);
        }

        .welcome-subtitle {
            font-size: 15px;
            color: var(--text-secondary);
            line-height: 1.4;
        }

        /* Form Styles */
        .form-container {
            margin-top: 10px;
        }

        .input-group {
            position: relative;
            margin-bottom: 20px;
        }

        .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--accent-gold);
            z-index: 2;
            font-size: 18px;
        }

        .form-input {
            width: 100%;
            padding: 16px 16px 16px 50px;
            border: 2px solid var(--border-color);
            border-radius: 12px;
            font-size: 16px;
            background: var(--secondary-bg);
            color: var(--text-primary);
            font-family: 'Noto Sans Bengali', sans-serif;
            transition: var(--transition);
        }

        .form-input:focus {
            outline: none;
            border-color: var(--accent-gold);
            box-shadow: 0 0 0 3px rgba(255, 215, 0, 0.1);
            background: var(--card-bg);
        }

        .form-input::placeholder {
            color: var(--text-muted);
            font-size: 14px;
        }

        /* Button Styles */
        .btn {
            padding: 16px;
            width: 100%;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: var(--transition);
            font-family: 'Noto Sans Bengali', sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin-bottom: 12px;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 215, 0, 0.4);
        }

        .btn-secondary {
            background: transparent;
            color: var(--accent-gold);
            border: 2px solid var(--accent-gold);
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.2);
        }

        .btn-secondary:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 215, 0, 0.3);
        }

        /* Agreement Section */
        .agreement-section {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-top: 20px;
            padding: 15px 0;
            border-top: 1px solid var(--border-color);
        }

        .agreement-checkbox {
            width: 18px;
            height: 18px;
            margin-right: 10px;
            accent-color: var(--accent-gold);
            cursor: pointer;
        }

        .agreement-label {
            font-size: 13px;
            color: var(--text-secondary);
            cursor: pointer;
            line-height: 1.4;
        }

        /* Footer Styles */
        .app-footer {
            background: var(--secondary-bg);
            padding: 15px 20px;
            border-top: 1px solid var(--border-color);
            text-align: center;
        }

        .footer-text {
            color: var(--text-muted);
            font-size: 12px;
        }

        /* Alert Message Styling */
        .alert-message {
            position: fixed;
            top: 80px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 1000;
            width: 90%;
            max-width: 400px;
            padding: 15px 20px;
            border-radius: 10px;
            font-weight: 600;
            text-align: center;
            border: 1px solid transparent;
            box-shadow: var(--box-shadow);
            backdrop-filter: blur(10px);
        }

        .alert-success {
            background: rgba(76, 175, 80, 0.95);
            color: white;
            border-color: #4CAF50;
        }

        .alert-error {
            background: rgba(244, 67, 54, 0.95);
            color: white;
            border-color: #f44336;
        }

        .alert-warning {
            background: rgba(255, 193, 7, 0.95);
            color: #000;
            border-color: var(--accent-gold);
        }

        /* Loading animation */
        .loading-spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(0, 0, 0, 0.3);
            border-radius: 50%;
            border-top-color: #000;
            animation: spin 1s ease-in-out infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Mobile Optimizations */
        @media (max-width: 480px) {
            .app-header {
                padding: 12px 15px;
            }
            
            .header-logo {
                width: 40px;
                height: 40px;
            }
            
            .app-name {
                font-size: 16px;
            }
            
            .language-btn {
                padding: 6px 12px;
                font-size: 12px;
            }
            
            .main-content {
                padding: 15px;
            }
            
            .login-container {
                padding: 25px 20px;
                margin: 10px 0;
            }
            
            .app-logo {
                width: 85px;
                height: 85px;
            }
            
            .welcome-title {
                font-size: 24px;
            }
            
            .welcome-subtitle {
                font-size: 14px;
            }
            
            .form-input {
                padding: 14px 14px 14px 45px;
                font-size: 15px;
            }
            
            .btn {
                padding: 14px;
                font-size: 15px;
            }
            
            .agreement-label {
                font-size: 12px;
            }
            
            .app-footer {
                padding: 12px 15px;
            }
        }

        @media (max-width: 360px) {
            .login-container {
                padding: 20px 15px;
            }
            
            .welcome-title {
                font-size: 22px;
            }
            
            .app-logo {
                width: 75px;
                height: 75px;
            }
        }

        /* Safe area support for notch phones */
        @supports(padding: max(0px)) {
            .main-content {
                padding-left: max(15px, env(safe-area-inset-left));
                padding-right: max(15px, env(safe-area-inset-right));
                padding-bottom: max(15px, env(safe-area-inset-bottom));
            }
            
            .app-header {
                padding-left: max(15px, env(safe-area-inset-left));
                padding-right: max(15px, env(safe-area-inset-right));
                padding-top: max(12px, env(safe-area-inset-top));
            }
        }
    </style>
</head>

<body>

<div id="app">
    <!-- Header -->
    <header class="app-header">
        <div class="header-left">
            <img src="/CodeKartLab/main-logo.png" alt="Logo" class="header-logo">
            <span class="app-name"><?php echo e(env('APP_NAME')); ?></span>
        </div>
        <button class="language-btn">বাংলা</button>
    </header>

    <!-- Alert Messages -->
    <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Main Content -->
    <main class="main-content">
        <div class="login-container">
            <div class="welcome-section">
                <img src="/CodeKartLab/main-logo.png" alt="App Logo" class="app-logo">
                <h1 class="welcome-title">স্বাগতম ফিরে</h1>
                <p class="welcome-subtitle">লগইন করতে আপনার ফোন নম্বর এবং পাসওয়ার্ড দিন</p>
            </div>

            <form id="loginForm" action="<?php echo e(route('login')); ?>" method="POST" class="form-container">
                <?php echo csrf_field(); ?>
                
                <div class="input-group">
                    <i class="fas fa-phone"></i>
                    <input type="text" name="phone" class="form-input" placeholder="আপনার ফোন নম্বর" value="<?php echo e(old('phone')); ?>" required>
                </div>
                
                <div class="input-group">
                    <i class="fas fa-lock"></i>
                    <input type="password" name="password" class="form-input" placeholder="আপনার পাসওয়ার্ড" required>
                </div>

                <button type="button" class="btn btn-primary" onclick="login()">
                    <i class="fas fa-sign-in-alt"></i>
                    লগইন করুন
                </button>
                
                <button type="button" class="btn btn-secondary" onclick="goLink('<?php echo e(url('make/account')); ?>')">
                    <i class="fas fa-user-plus"></i>
                    নিবন্ধন করুন
                </button>

                <div class="agreement-section">
                    <input type="checkbox" id="agreementCheckbox" class="agreement-checkbox" checked required>
                    <label for="agreementCheckbox" class="agreement-label">
                        আমি ব্যবহারকারী চুক্তি এবং গোপনীয়তা নীতি পড়েছি এবং সম্মত আছি
                    </label>
                </div>
            </form>
        </div>
    </main>

    <!-- Footer -->
    <footer class="app-footer">
        <p class="footer-text">© 2024 <?php echo e(env('APP_NAME')); ?> - সকল অধিকার সংরক্ষিত</p>
    </footer>
</div>

<script>
    function loading() {
        const loginBtn = document.querySelector('.btn-primary');
        const originalHTML = loginBtn.innerHTML;
        loginBtn.innerHTML = '<div class="loading-spinner"></div> প্রসেসিং...';
        loginBtn.style.opacity = '0.7';
        loginBtn.style.pointerEvents = 'none';
        
        // Reset after 3 seconds if still loading
        setTimeout(() => {
            loginBtn.innerHTML = originalHTML;
            loginBtn.style.opacity = '1';
            loginBtn.style.pointerEvents = 'auto';
        }, 3000);
    }

    function notice(message) {
        if (typeof layer !== 'undefined') {
            layer.msg(message);
        } else {
            // Custom alert styling
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert-message alert-warning';
            alertDiv.textContent = message;
            document.body.appendChild(alertDiv);
            
            setTimeout(() => {
                alertDiv.remove();
            }, 3000);
        }
    }

    function login() {
        const form = document.getElementById('loginForm');
        const phone = form.querySelector('input[name="phone"]').value;
        const password = form.querySelector('input[name="password"]').value;
        const isAgreed = document.getElementById('agreementCheckbox').checked;

        if (!phone || !password) {
            notice('অনুগ্রহ করে ফোন নম্বর এবং পাসওয়ার্ড সঠিকভাবে দিন।');
            return;
        }

        if (!isAgreed) {
            notice('লগইন করার জন্য ব্যবহারকারী চুক্তিতে সম্মত হতে হবে।');
            return;
        }

        // Phone number validation for Bangladesh
        const phoneRegex = /^01[3-9]\d{8}$/;
        if (!phoneRegex.test(phone)) {
            notice('অনুগ্রহ করে একটি সঠিক বাংলাদেশী ফোন নম্বর দিন (01XXXXXXXXX)।');
            return;
        }

        loading(); 
        form.submit(); 
    }

    function goLink(url) {
        window.location.href = url;
    }

    // Add interactive effects
    document.addEventListener('DOMContentLoaded', function() {
        const inputs = document.querySelectorAll('.form-input');
        const buttons = document.querySelectorAll('.btn');
        
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'translateY(-2px)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'translateY(0)';
            });
        });
        
        buttons.forEach(btn => {
            btn.addEventListener('mousedown', function() {
                this.style.transform = 'scale(0.98)';
            });
            
            btn.addEventListener('mouseup', function() {
                if (this.classList.contains('btn-primary') || this.classList.contains('btn-secondary')) {
                    this.style.transform = 'translateY(-2px)';
                } else {
                    this.style.transform = '';
                }
            });
        });

        // Handle mobile viewport height
        function setVH() {
            let vh = window.innerHeight * 0.01;
            document.documentElement.style.setProperty('--vh', `${vh}px`);
        }
        
        setVH();
        window.addEventListener('resize', setVH);
        window.addEventListener('orientationchange', setVH);
    });
</script>

</body>
</html><?php /**PATH /home/sitezoo/greenbazarbd.sbs/resources/views/app/auth/login.blade.php ENDPATH**/ ?>