<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, viewport-fit=cover">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(env('APP_NAME')); ?></title>

    <link rel="icon" href="/CodeKartLab/main-logo.png" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }
        
        * { 
            margin: 0; 
            padding: 0; 
            box-sizing: border-box; 
        }
        
        body { 
            font-family: 'Noto Sans Bengali', sans-serif; 
            background: var(--primary-bg); 
            color: var(--text-primary); 
            line-height: 1.5;
        }
        
        #app-container { 
            display: flex; 
            flex-direction: column; 
            min-height: 100vh; 
        }
        
        .header-fixed { 
            position: fixed; 
            top: 0; 
            width: 100%; 
            z-index: 1000;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
            background: var(--secondary-bg);
            border-bottom: 1px solid var(--border-color);
        }
        
        main { 
            flex: 1; 
            overflow-y: auto; 
            padding-top: 70px; 
            padding-bottom: 80px; 
            background: var(--primary-bg); 
        }
        
        .footer-fixed { 
            position: fixed; 
            bottom: 0; 
            width: 100%; 
            z-index: 1000;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
            background: var(--secondary-bg);
            border-top: 1px solid var(--border-color);
        }
        
        .header { 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
            padding: 12px 20px; 
            background: var(--secondary-bg); 
        }
        
        .header .left { 
            display: flex; 
            align-items: center; 
            gap: 12px; 
        }
        
        .header .left img { 
            width: 42px; 
            height: 42px; 
            border-radius: 50%; 
            border: 2px solid var(--accent-gold);
        }
        
        .header .left span { 
            color: var(--text-primary); 
            font-weight: 700; 
            font-size: 18px;
        }
        
        .lang-btn { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            border: none; 
            padding: 6px 14px; 
            font-weight: 600; 
            border-radius: 20px; 
            font-size: 14px; 
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }
        
        .lang-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.4);
        }
        
        .hero-img { 
            position: relative;
            overflow: hidden;
            border-radius: 0 0 var(--border-radius) var(--border-radius);
            box-shadow: var(--box-shadow);
        }
        
        .hero-img img { 
            width: 100%; 
            max-height: 200px; 
            object-fit: cover; 
            display: block;
        }
        
        .marquee-container { 
            background: var(--secondary-bg); 
            padding: 12px 15px; 
            font-size: 14px; 
            color: var(--accent-gold); 
            overflow: hidden; 
            border-bottom: 1px solid var(--border-color);
            margin-bottom: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        
        .icon-grid { 
            display: grid; 
            grid-template-columns: repeat(4, 1fr); 
            gap: 15px; 
            padding: 20px 15px; 
            background: var(--card-bg); 
            border-radius: var(--border-radius);
            margin: 0 15px 20px;
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
        }
        
        .icon-box { 
            text-align: center; 
            color: inherit; 
            text-decoration: none; 
            padding: 15px 5px;
            border-radius: 12px;
            transition: var(--transition);
            background: var(--secondary-bg);
            border: 1px solid var(--border-color);
            position: relative;
        }
        
        .icon-box:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: translateY(-3px);
            border-color: var(--accent-gold);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.2);
        }
        
        .icon-box i { 
            font-size: 28px; 
            color: var(--accent-gold); 
            margin-bottom: 10px; 
            display: inline-block;
            transition: var(--transition);
        }
        
        .icon-box:hover i {
            transform: scale(1.1);
            color: var(--accent-gold-light);
        }
        
        .icon-box p { 
            font-size: 13px; 
            font-weight: 600; 
            margin: 0; 
            color: var(--text-primary);
        }
        
        /* Improved Icons with decorative elements */
        .icon-box.mining::after {
            content: '⛏️';
            position: absolute;
            font-size: 12px;
            top: 8px;
            right: 8px;
            opacity: 0.8;
        }
        
        .icon-box.lottery::after {
            content: '🎯';
            position: absolute;
            font-size: 10px;
            top: 8px;
            right: 8px;
            opacity: 0.8;
        }
        
        .icon-box.coupon::after {
            content: '🏷️';
            position: absolute;
            font-size: 10px;
            top: 8px;
            right: 8px;
            opacity: 0.8;
        }
        
        .icon-box.about::after {
            content: 'ℹ️';
            position: absolute;
            font-size: 10px;
            top: 8px;
            right: 8px;
            opacity: 0.8;
        }
        
        .icon-box.support::after {
            content: '💬';
            position: absolute;
            font-size: 10px;
            top: 8px;
            right: 8px;
            opacity: 0.8;
        }
        
        .icon-box.apps::after {
            content: '📱';
            position: absolute;
            font-size: 10px;
            top: 8px;
            right: 8px;
            opacity: 0.8;
        }
        
        .icon-box.invite::after {
            content: '👥';
            position: absolute;
            font-size: 10px;
            top: 8px;
            right: 8px;
            opacity: 0.8;
        }
        
        .counter-box { 
            background: linear-gradient(135deg, #2a2a2a, #1a1a1a); 
            margin: 20px 15px; 
            padding: 20px 15px; 
            border-radius: var(--border-radius); 
            text-align: center; 
            font-weight: 600; 
            font-size: 16px; 
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }
        
        .counter-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
        }
        
        #counter { 
            margin-top: 10px; 
            font-size: 22px; 
            color: var(--accent-gold); 
            font-weight: 700;
        }
        
        .plan-card { 
            background: var(--card-bg); 
            margin: 20px 15px; 
            border-radius: var(--border-radius); 
            box-shadow: var(--box-shadow); 
            overflow: hidden; 
            position: relative; 
            font-size: 14px; 
            transition: var(--transition);
            border: 1px solid var(--border-color);
        }
        
        .plan-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.5);
            border-color: var(--accent-gold);
        }
        
        .plan-card .fire-icon { 
            position: absolute; 
            top: -5px; 
            left: -5px; 
            width: 40px; 
        }
        
        .plan-header { 
            display: flex; 
            align-items: center; 
            gap: 15px; 
            padding: 20px; 
            background: linear-gradient(to right, #2a2a2a, #1f1f1f);
            border-bottom: 1px solid var(--border-color);
        }
        
        .plan-header img { 
            width: 80px; 
            height: 80px; 
            border-radius: 12px; 
            object-fit: cover; 
            border: 2px solid var(--accent-gold);
        }
        
        .plan-title { 
            font-weight: 700; 
            color: var(--text-primary); 
            font-size: 18px; 
        }
        
        .plan-details { 
            padding: 15px 20px 15px; 
        }
        
        .plan-table { 
            width: 100%; 
            font-size: 14px; 
            border-collapse: collapse; 
            margin-top: 5px; 
        }
        
        .plan-table td { 
            padding: 8px 0; 
            border-bottom: 1px dashed var(--border-color);
            color: var(--text-secondary);
        }
        
        .plan-table tr:last-child td {
            border-bottom: none;
        }
        
        .plan-footer { 
            background: linear-gradient(to right, #2a2a2a, #1f1f1f); 
            padding: 15px 20px; 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
            border-top: 1px solid var(--border-color); 
        }
        
        .plan-price { 
            font-weight: 700; 
            color: var(--accent-gold); 
            font-size: 18px; 
        }
        
        .buy-btn { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            padding: 10px 20px; 
            font-size: 14px; 
            font-weight: 700; 
            border: none; 
            border-radius: 12px; 
            cursor: pointer; 
            text-decoration: none; 
            color: #000; 
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }
        
        .buy-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }
        
        .bottom-nav { 
            display: flex; 
            justify-content: space-around; 
            background: var(--secondary-bg); 
            border-top: 1px solid var(--border-color); 
            padding: 12px 0; 
        }
        
        .nav-item { 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            text-decoration: none; 
            color: var(--text-muted); 
            font-size: 12px; 
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
        }
        
        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }
        
        .nav-item .icon-wrap { 
            width: 40px; 
            height: 40px; 
            border-radius: 10px; 
            display: flex; 
            justify-content: center; 
            align-items: center; 
            margin-bottom: 5px; 
            transition: var(--transition);
            background: var(--card-bg);
        }
        
        .nav-item i { 
            font-size: 18px; 
        }
        
        .nav-item.active .icon-wrap { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }
        
        .nav-item.active span { 
            color: var(--accent-gold); 
            font-weight: 600;
        }
        
        .alert { 
            padding: 15px; 
            margin: 15px; 
            border-radius: 12px; 
            font-weight: 600; 
            text-align: center; 
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            background: var(--card-bg);
            border-left: 4px solid var(--accent-gold);
            color: var(--text-primary);
        }
        
        .alert-success { 
            background: var(--card-bg); 
            color: var(--text-primary); 
            border-left: 4px solid var(--success);
        }
        
        /* Gold accent elements */
        .gold-accent {
            color: var(--accent-gold);
        }
        
        .gold-border {
            border-color: var(--accent-gold);
        }
        
        /* Responsive adjustments */
        @media (max-width: 480px) {
            .icon-grid {
                grid-template-columns: repeat(4, 1fr);
                gap: 10px;
                padding: 15px 10px;
            }
            
            .plan-header {
                padding: 15px;
            }
            
            .plan-details {
                padding: 10px 15px 10px;
            }
            
            .plan-footer {
                padding: 12px 15px;
            }
        }
        
        @media (max-width: 360px) {
            .icon-grid {
                grid-template-columns: repeat(3, 1fr);
            }
        }
        
        /* Scrollbar styling */
        ::-webkit-scrollbar {
            width: 6px;
        }
        
        ::-webkit-scrollbar-track {
            background: var(--secondary-bg);
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--accent-gold);
            border-radius: 3px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: var(--accent-gold-light);
        }
    </style>
</head>
<body>

<?php
    $plans = \App\Models\Package::where('status', 'active')->get(); 
?>

<div id="app-container">
    
    <div class="header-fixed">
        <div class="header">
            <div class="left">
                <img src="/CodeKartLab/main-logo.png" alt="logo">
                <span>বাংলা</span>
            </div>
            <button class="lang-btn">বাংলা</button>
        </div>
    </div>

    <main>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        
        <div class="hero-img">
            <img src="/CodeKartLab/home-main.jpg" alt="Banner">
        </div>

        <div class="marquee-container">
            <marquee>📢 স্বাগতম  Green Bazar BD এ – আপনার নির্ভরযোগ্য ইনভেস্টমেন্ট পার্টনার! 🚀 নিরাপদ ও লাভজনক প্ল্যানে বিনিয়োগ করুন, প্রতিদিন আয় করুন শুধুই Green Bazar BD থেকে!.</marquee>
        </div>

        
        <div class="icon-grid">
            <a href="<?php echo e(url('/history')); ?>" class="icon-box"><i class="fas fa-chart-line"></i><p>আয়কর</p></a>
            <a href="<?php echo e(url('ordered')); ?>" class="icon-box mining"><i class="fas fa-hammer"></i><p>খননকারী</p></a>
            <a href="/spin" class="icon-box lottery"><i class="fas fa-dice"></i><p>লটারি</p></a>
            <a href="<?php echo e(url('service')); ?>" class="icon-box coupon"><i class="fas fa-tags"></i><p>কূপন</p></a>
            <a href="/about" class="icon-box about"><i class="fas fa-building"></i><p>সম্পর্কে</p></a>
            <a href="/support" class="icon-box support"><i class="fas fa-comments"></i><p>সাপোর্ট</p></a>
            <a href="" class="icon-box apps"><i class="fas fa-mobile-alt"></i><p>অ্যাপস</p></a>
            <a href="/my-team" class="icon-box invite"><i class="fas fa-user-plus"></i><p>আমন্ত্রণ</p></a>
        </div>

        <div class="counter-box">
            <div>প্ল্যাটফর্ম নিরাপদে চলছে</div>
            <div id="counter">লোড হচ্ছে...</div>
        </div>
      
        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="plan-card">
                 <div class="plan-header">
                    <img src="<?php echo e(asset($plan->photo)); ?>" alt="<?php echo e($plan->name); ?>">
                    <div class="plan-title"><?php echo e($plan->name); ?></div>
                </div>
                 <div class="plan-details">
                    <table class="plan-table">
                        <tr>
                            <td>দৈনিক ইনকাম</td>
                            <td class="gold-accent"><b>৳<?php echo e(number_format($plan->commission_with_avg_amount / $plan->validity, 2)); ?></b></td>
                            <td class="ps-1">মোট রিটার্ন</td>
                            <td class="text-end gold-accent"><b>৳<?php echo e(number_format($plan->commission_with_avg_amount, 2)); ?></b></td>
                        </tr>
                        <tr>
                            <td>সর্বোচ্চ পারচেস</td>
                            <td class="text-end"><b><?php echo e($plan->max_purchase ?? '1'); ?></b></td>
                            <td class="ps-1">চুক্তির মেয়াদ</td>
                            <td class="text-end"><b><?php echo e($plan->validity); ?> দিন</b></td>
                        </tr>
                    </table>
                </div>

                <div class="plan-footer">
                    <div class="plan-price"><?php echo e(number_format($plan->price, 2)); ?> ৳</div>
                    
                    
                    <a href="<?php echo e(route('purchase.confirmation', ['id' => $plan->id])); ?>" class="buy-btn">
                        কিনুন ৳<?php echo e(number_format($plan->price, 2)); ?>

                    </a>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </main>

    
    <div class="footer-fixed">
        <footer class="bottom-nav">
            <a href="<?php echo e(url('home')); ?>" class="nav-item active">
                <div class="icon-wrap"><i class="fas fa-home"></i></div>
                <span>হোম</span>
            </a>
            <a href="<?php echo e(url('ordered')); ?>" class="nav-item">
                <div class="icon-wrap"><i class="fas fa-store"></i></div>
                <span>আমার খনন</span>
            </a>
            <a href="<?php echo e(url('my-team')); ?>" class="nav-item">
                <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
                <span> আমন্ত্রণ</span>
            </a>
            <a href="<?php echo e(url('profile')); ?>" class="nav-item">
                <div class="icon-wrap"><i class="fas fa-user"></i></div>
                <span>আমার</span>
            </a>
        </footer>
    </div>

</div>

<script>
   
    const startDate = new Date("2024-01-01T00:00:00");
    function updateCounter() {
        const now = new Date();
        const diff = now - startDate;
        const days = Math.floor(diff / (1000 * 60 * 60 * 24));
        const hours = Math.floor((diff % (1000 * 60 * <?php /**PATH /home/sitezoo/greenbazarbd.sbs/resources/views/app/main/index.blade.php ENDPATH**/ ?>