<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900" style="color: var(--accent-gold); font-size: 24px; font-weight: 700; margin-bottom: 10px;">
            {{ __('পাসওয়ার্ড আপডেট করুন') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600" style="color: var(--text-secondary); font-size: 14px; line-height: 1.5;">
            {{ __('আপনার অ্যাকাউন্ট সুরক্ষিত রাখতে একটি দীর্ঘ এবং শক্তিশালী পাসওয়ার্ড ব্যবহার করুন।') }}
        </p>
    </header>

    <form method="post" action="{{ route('password.update') }}" class="mt-6 space-y-6" style="margin-top: 30px;">
        @csrf
        @method('put')

        <div style="margin-bottom: 20px;">
            <x-input-label for="current_password" :value="__('বর্তমান পাসওয়ার্ড')" style="display: block; margin-bottom: 8px; color: var(--text-secondary); font-size: 14px; font-weight: 600;" />
            <x-text-input id="current_password" name="current_password" type="password" class="mt-1 block w-full" autocomplete="current-password" 
                style="width: 100%; padding: 16px; background: var(--secondary-bg); border: 2px solid var(--border-color); border-radius: 12px; color: var(--text-primary); font-size: 15px; transition: all 0.3s ease; font-family: 'Noto Sans Bengali', sans-serif;" />
            <x-input-error :messages="$errors->updatePassword->get('current_password')" class="mt-2" 
                style="color: #ff6b6b; font-size: 14px; margin-top: 8px;" />
        </div>

        <div style="margin-bottom: 20px;">
            <x-input-label for="password" :value="__('নতুন পাসওয়ার্ড')" style="display: block; margin-bottom: 8px; color: var(--text-secondary); font-size: 14px; font-weight: 600;" />
            <x-text-input id="password" name="password" type="password" class="mt-1 block w-full" autocomplete="new-password" 
                style="width: 100%; padding: 16px; background: var(--secondary-bg); border: 2px solid var(--border-color); border-radius: 12px; color: var(--text-primary); font-size: 15px; transition: all 0.3s ease; font-family: 'Noto Sans Bengali', sans-serif;" />
            <x-input-error :messages="$errors->updatePassword->get('password')" class="mt-2" 
                style="color: #ff6b6b; font-size: 14px; margin-top: 8px;" />
        </div>

        <div style="margin-bottom: 20px;">
            <x-input-label for="password_confirmation" :value="__('পাসওয়ার্ড নিশ্চিত করুন')" style="display: block; margin-bottom: 8px; color: var(--text-secondary); font-size: 14px; font-weight: 600;" />
            <x-text-input id="password_confirmation" name="password_confirmation" type="password" class="mt-1 block w-full" autocomplete="new-password" 
                style="width: 100%; padding: 16px; background: var(--secondary-bg); border: 2px solid var(--border-color); border-radius: 12px; color: var(--text-primary); font-size: 15px; transition: all 0.3s ease; font-family: 'Noto Sans Bengali', sans-serif;" />
            <x-input-error :messages="$errors->updatePassword->get('password_confirmation')" class="mt-2" 
                style="color: #ff6b6b; font-size: 14px; margin-top: 8px;" />
        </div>

        <div class="flex items-center gap-4" style="display: flex; align-items: center; gap: 15px;">
            <x-primary-button style="background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); color: #000; border: none; padding: 14px 30px; border-radius: 12px; font-size: 16px; font-weight: 700; cursor: pointer; transition: all 0.3s ease; box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);">
                {{ __('সংরক্ষণ করুন') }}
            </x-primary-button>

            @if (session('status') === 'password-updated')
                <p
                    x-data="{ show: true }"
                    x-show="show"
                    x-transition
                    x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-gray-600"
                    style="color: var(--accent-gold); font-size: 14px; font-weight: 600;"
                >{{ __('সংরক্ষিত হয়েছে।') }}</p>
            @endif
        </div>
    </form>
</section>

<style>
    :root {
        --primary-bg: #0a0a0a;
        --secondary-bg: #1a1a1a;
        --card-bg: #1e1e1e;
        --accent-gold: #ffd700;
        --accent-gold-light: #ffed4e;
        --accent-gold-dark: #b39700;
        --text-primary: #ffffff;
        --text-secondary: #cccccc;
        --text-muted: #888888;
        --border-color: #333333;
        --border-radius: 16px;
        --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
        --transition: all 0.3s ease;
    }

    section {
        background: var(--card-bg);
        padding: 30px 25px;
        border-radius: var(--border-radius);
        box-shadow: var(--box-shadow);
        border: 1px solid var(--border-color);
        margin: 20px 0;
    }

    x-text-input:focus {
        outline: none;
        border-color: var(--accent-gold) !important;
        box-shadow: 0 0 0 3px rgba(255, 215, 0, 0.1) !important;
    }

    x-primary-button:hover {
        background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold)) !important;
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(255, 215, 0, 0.4) !important;
    }

    @media (max-width: 480px) {
        section {
            padding: 25px 20px;
            margin: 15px 10px;
        }

        x-text-input {
            padding: 14px !important;
            font-size: 14px !important;
        }

        x-primary-button {
            padding: 12px 25px !important;
            font-size: 15px !important;
            width: 100%;
            justify-content: center;
        }

        .flex.items-center.gap-4 {
            flex-direction: column;
            align-items: stretch;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Add focus effects to input fields
        const inputs = document.querySelectorAll('x-text-input, input[type="password"]');
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.style.transform = 'translateY(-2px)';
            });
            
            input.addEventListener('blur', function() {
                this.style.transform = 'translateY(0)';
            });
        });

        // Add button click effect
        const button = document.querySelector('x-primary-button');
        if (button) {
            button.addEventListener('mousedown', function() {
                this.style.transform = 'scale(0.98)';
            });
            
            button.addEventListener('mouseup', function() {
                this.style.transform = '';
            });
        }
    });
</script>