<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ env('APP_NAME') }}</title>

    
    <link rel="icon" href="/smartlab/smartlab.png" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        body {
            background: #f4fff0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            color: #204718;
        }
        main {
            max-width: 500px;
            margin: auto;
        }
        .container {
            max-width: 420px;
            margin: 0 auto;
            padding: 70px 15px 100px; 
        }
        .navbar {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            max-width: 500px;
            margin: auto;
            width: 100%;
            height: 55px;
            background: linear-gradient(90deg, #d4ffc8, #bdfab0);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #205715;
            font-weight: 700;
            font-size: 20px;
            z-index: 1000;
            border-bottom: 1px solid #b7f0a4;
        }
        .navbar .back-button {
            position: absolute;
            left: 15px;
            color: #205715;
            font-size: 24px;
            text-decoration: none;
        }

     
        form {
            background: #e2f9d9;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 1px 4px rgba(0,0,0,0.05);
        }
        /* Balance Display */
        .balance-box {
            background: #e2f9d9;
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 16px;
            font-weight: 600;
        }
        .balance-box .label {
            font-size: 14px;
            color: #555;
        }
        .balance-box .value {
            font-size: 24px;
            font-weight: 800;
            color: #204718;
        }

        form input,
        form select {
            width: 100%;
            background: #f0ffe8;
            border: 1px solid #a3f29c;
            padding: 12px 15px;
            font-size: 16px;
            font-weight: 600;
            color: #204718;
            margin-bottom: 16px;
            border-radius: 8px;
            box-sizing: border-box;
        }
        form input[readonly] {
            background: #d1eed1;
            font-weight: bold;
        }

        
        .submit-btn {
            width: 100%;
            background: linear-gradient(90deg, #bff0ab, #9ee28a);
            border: none;
            padding: 13px;
            font-size: 16px;
            font-weight: 800;
            color: #1d3f0f;
            cursor: pointer;
            border-radius: 8px;
            display: block;
            text-align: center;
        }
        .submit-btn:hover {
            background: linear-gradient(90deg, #a4e891, #85d371);
        }

       
        .notice-box {
            background: #edffe5;
            padding: 20px;
            margin-top: 25px;
            font-size: 13px;
            line-height: 1.6;
            border-left: 4px solid #96d780;
            border-radius: 8px;
        }
        .notice-box h2 {
            font-size: 15px;
            color: #2c5a1d;
            margin-top: 0;
            margin-bottom: 10px;
        }
        .notice-box ul {
            padding-left: 18px;
            margin-bottom: 0;
        }
        .notice-box li {
            margin-bottom: 6px;
        }

       
        .toast-notification {
            position: fixed;
            top: 70px; 
            left: 50%;
            transform: translateX(-50%);
            background-color: #22c55e; 
            color: white;
            padding: 12px 25px;
            border-radius: 25px;
            z-index: 9999;
            font-size: 15px;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
            display: none; 
            opacity: 0;
            transition: opacity 0.5s ease-in-out;
        }
        .toast-notification.show {
            display: block;
            opacity: 1;
        }

       
        .bottom-nav {
            position: fixed; bottom: 0; left: 0; right: 0; max-width: 500px;
            margin: auto; width: 100%; display: flex; justify-content: space-around;
            background: #d1ffcc; border-top: 1px solid #e0e0e0; padding: 8px 0; z-index: 1000;
        }
        .nav-item { display: flex; flex-direction: column; align-items: center; text-decoration: none; color: #444; font-size: 12px; }
        .nav-item .icon-wrap { width: 32px; height: 32px; border-radius: 5px; display: flex; justify-content: center; align-items: center; margin-bottom: 4px; }
        .nav-item i { font-size: 16px; }
        .nav-item.active .icon-wrap { background-color: #c7e70f; color: black; }
        .nav-item.active span { color: black; }
    </style>
</head>

<body>
    <main>
        <div class="navbar">
            <a href="/" class="back-button"><i class="fas fa-arrow-left"></i></a>
            Withdrawal
        </div>

      
        @if(session('success'))
            <div id="toast-notification" class="toast-notification">
                {{ session('success') }}
            </div>
        @endif
        
        <div class="container">
            
            <div class="balance-box">
                <div class="label">Available balance</div>
                <div class="value">{{ price(user()->balance) }}</div>
            </div>

            <form id="withdraw-form" action="{{ route('user.withdraw.request') }}" method="POST" autocomplete="off">
                @csrf
                <label for="wallet_info">Wallet</label>
                <input id="wallet_info" type="text" value="{{ user()->gateway_method }} - {{ user()->gateway_number }}" readonly>
                
                <label for="amount">Withdrawal amount</label>
                <input id="amount" type="number" name="amount" min="200" placeholder="Enter the amount" required>
            </form>
            
            <div class="submit-btn" onclick="withdrawal()">Go Ahead</div>

            <div class="notice-box">
                <h2>Withdrawal Guidelines</h2>
                <ul>
                    <li>The minimum withdrawal amount is ৳200, and you can withdraw only once a day.</li>
                    <li>Withdrawal will reach your wallet within 1-24 hours.</li>
                    <li>Equipment damage fee is 7%.</li>
                    <li>Pick up time is 10:00 am to 18:00 pm daily (including holidays and weekends).</li>
                    <li>To verify the user's authenticity, the user needs to activate the cash withdrawal function after purchasing 1 item.</li>
                </ul>
            </div>
        </div>
    </main>

    <footer class="bottom-nav">
        
    </footer>
    
    <script>
        function withdrawal(){
            document.getElementById('withdraw-form').submit();
        }

        
        window.onload = function() {
            var toast = document.getElementById('toast-notification');
            if (toast) {
               
                toast.classList.add('show');

                
                setTimeout(function() {
                    toast.classList.remove('show');
                }, 5000); 
            }
        };
    </script>
</body>
</html>