<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, viewport-fit=cover">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{env('APP_NAME')}} </title>

    
    <link rel="icon" href="/smartlab/smartlab.png" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }
        
        body {
            font-family: 'Segoe UI', 'Montserrat', 'Noto Sans Bengali', sans-serif;
            background: var(--primary-bg);
            margin: 0;
            padding: 0;
            color: var(--text-primary);
        }

        main {
            max-width: 500px;
            margin: auto;
            background: var(--primary-bg);
            padding-bottom: 100px;
        }

        .container {
            padding: 25px 20px;
        }
        
       
        .stat-boxes {
            display: flex;
            gap: 15px;
            justify-content: space-between;
            margin-bottom: 25px;
        }
        .stat-card {
            background: var(--card-bg);
            padding: 20px 15px;
            flex: 1;
            text-align: left;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
        }

        .stat-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
            border-color: var(--accent-gold);
        }

        .stat-card .value {
            font-size: 24px;
            font-weight: bold;
            color: var(--accent-gold);
            margin-bottom: 5px;
        }
        .stat-card .title {
            font-size: 14px;
            color: var(--text-secondary);
        }

        
        .qr-section {
            text-align: center;
            margin-bottom: 20px;
            padding: 25px 20px;
            background: var(--card-bg);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            transition: var(--transition);
            position: relative;
        }

        .qr-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .qr-section:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
        }

        .qr-section img {
            width: 150px;
            height: 150px;
            border: 4px solid var(--accent-gold);
            border-radius: 12px;
            transition: var(--transition);
        }

        .qr-section:hover img {
            transform: scale(1.05);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.3);
        }

        .ref-code {
            margin-top: 15px;
            font-size: 20px;
            color: var(--accent-gold);
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

         .invite-box {
            background: var(--card-bg);
            padding: 20px;
            margin-bottom: 20px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            transition: var(--transition);
            position: relative;
        }

        .invite-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .invite-box:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
        }

        .invite-box h3 {
            color: var(--accent-gold);
            margin-bottom: 10px;
            font-size: 18px;
        }

        .invite-box p {
            font-size: 14px;
            margin-bottom: 8px;
            color: var(--text-secondary);
        }

        .copy-btn {
            background: none; 
            border: none; 
            font-size: 18px; 
            cursor: pointer; 
            color: var(--accent-gold); 
            vertical-align: middle;
            transition: var(--transition);
            padding: 5px;
            border-radius: 50%;
        }

        .copy-btn:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: scale(1.1);
        }

        .link {
            font-size: 13px; 
            color: var(--text-secondary); 
            padding: 10px 15px; 
            word-break: break-all; 
            background-color: var(--secondary-bg);
            border-radius: 20px; 
            display: inline-block; 
            margin-top: 10px;
            border: 1px solid var(--border-color);
        }

        .copy-link-btn {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            border: none; 
            padding: 12px 30px; 
            font-weight: bold; 
            cursor: pointer;
            margin-top: 15px; 
            border-radius: 25px; 
            font-size: 16px;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }

        .copy-link-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }

        .steps .step {
            background: rgba(255, 215, 0, 0.1);
            padding: 12px 15px;
            margin: 8px 0;
            font-size: 14px;
            color: var(--text-primary);
            font-weight: 600;
            border-radius: 8px;
            border-left: 3px solid var(--accent-gold);
            transition: var(--transition);
        }

        .steps .step:hover {
            background: rgba(255, 215, 0, 0.15);
            transform: translateX(5px);
        }

        
        .rules { 
            background: var(--card-bg); 
            padding: 25px 20px; 
            margin-top: 30px; 
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            transition: var(--transition);
            position: relative;
        }

        .rules::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .rules:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
        }

        .rules h3 { 
            color: var(--accent-gold); 
            margin-bottom: 20px; 
            text-align: center; 
            font-size: 20px;
        }
        .rules p { 
            font-size: 14px; 
            color: var(--text-secondary); 
            margin-bottom: 15px; 
            line-height: 1.7; 
            padding-left: 10px;
            border-left: 2px solid transparent;
            transition: var(--transition);
        }

        .rules p:hover {
            border-left: 2px solid var(--accent-gold);
            padding-left: 15px;
            color: var(--text-primary);
        }
        
      
        .bottom-nav {
            position: fixed; 
            bottom: 0; 
            left: 0; 
            right: 0; 
            max-width: 500px; 
            margin: auto; 
            width: 100%;
            display: flex; 
            justify-content: space-around; 
            background: var(--secondary-bg); 
            border-top: 1px solid var(--border-color);
            padding: 12px 0; 
            z-index: 1000;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
        }

        .nav-item {
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            text-decoration: none;
            color: var(--text-muted); 
            font-size: 12px;
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }

        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }

        .nav-item .icon-wrap {
            width: 40px; 
            height: 40px; 
            border-radius: 10px; 
            display: flex; 
            justify-content: center;
            align-items: center; 
            margin-bottom: 5px; 
            transition: var(--transition);
            background: var(--card-bg);
        }

        .nav-item i { 
            font-size: 18px; 
        }

        .nav-item.active .icon-wrap { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }

        .nav-item.active span { 
            color: var(--accent-gold); 
            font-weight: 600;
        }

        /* Success notification */
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            background: var(--accent-gold);
            color: #000;
            padding: 15px 20px;
            border-radius: 10px;
            box-shadow: var(--box-shadow);
            z-index: 10000;
            transform: translateX(150%);
            transition: transform 0.3s ease;
            font-weight: 600;
        }

        .notification.show {
            transform: translateX(0);
        }

        /* Scrollbar styling */
        ::-webkit-scrollbar {
            width: 6px;
        }
        
        ::-webkit-scrollbar-track {
            background: var(--secondary-bg);
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--accent-gold);
            border-radius: 3px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: var(--accent-gold-light);
        }

        /* Responsive adjustments */
        @media (max-width: 480px) {
            .container {
                padding: 20px 15px;
            }
            
            .stat-boxes {
                gap: 10px;
            }
            
            .stat-card {
                padding: 15px 10px;
            }
            
            .stat-card .value {
                font-size: 20px;
            }
            
            .qr-section {
                padding: 20px 15px;
            }
            
            .qr-section img {
                width: 130px;
                height: 130px;
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }
    </style>
</head>

<body>
    @php
        $ref_link = url('/make/account').'?inviteCode='.auth()->user()->ref_id;
    @endphp

    <!-- Notification Element -->
    <div class="notification" id="notification"></div>

    <main>
        <div class="container">
            <div class="stat-boxes">
                <div class="stat-card">
                    <div class="value">{{ $team_size }}</div>
                    <div class="title">মোট দলের আকার</div>
                </div>
                <div class="stat-card">
                    <div class="value">{{ price($levelTotalCommission1 + $levelTotalCommission2 + $levelTotalCommission3) }}</div>
                    <div class="title">মোট আয়</div>
                </div>
            </div>

            <div class="qr-section">
                <img src="https://api.qrserver.com/v1/create-qr-code/?size=180x180&data={{ $ref_link }}" alt="Referral QR Code">
                <h2 class="ref-code">
                    {{ auth()->user()->ref_id }}
                    <button class="copy-btn" onclick="copyLink('{{ auth()->user()->ref_id }}', 'Referral code')">
                        <i class="far fa-copy"></i>
                    </button>
                </h2>
                <p class="link">{{ $ref_link }}</p>
                <button class="copy-link-btn" onclick="copyLink('{{ $ref_link }}', 'Referral link')">
                    <i class="fas fa-link me-2"></i>লিংক কপি করুন
                </button>
            </div>

            <div class="invite-box">
                <h3><i class="fas fa-user-plus me-2"></i>আপনার বন্ধুদের আমন্ত্রণ</h3>
                <p>লেনদেন থেকে ৭% পর্যন্ত ক্যাশব্যাক পান</p>
                <div class="steps">
                    <div class="step">১. আপনার বন্ধুদের আমন্ত্রণ পাঠান</div>
                    <div class="step">২. তাদের নিবন্ধন করতে এবং ব্যবসা করতে দিন</div>
                    <div class="step">৩. আনুপাতিক পুরষ্কার অর্জন করুন</div>
                </div>
            </div>
           
            <div class="rules">
                <h3><i class="fas fa-award me-2"></i>পুরস্কারের নিয়ম</h3>
                <p>যখন আপনি কোনও সদস্যকে নিবন্ধন এবং বিনিয়োগের জন্য আমন্ত্রণ জানান, তখন আপনি তাৎক্ষণিকভাবে নির্দিষ্ট বিনিয়োগের পরিমাণের 30% নগদ পুরস্কার পাবেন।</p>
                <p>আপনার লেভেল ২ টিমের সদস্যরা বিনিয়োগ করার পরে, আপনি বিনিয়োগের পরিমাণের ১% নগদ বোনাস পাবেন।</p>
                <p>আপনার লেভেল ৩ টিমের সদস্যরা বিনিয়োগ করার পরে, আপনি বিনিয়োগের পরিমাণের ১% নগদ বোনাস পাবেন।</p>
                <p>আপনার দলের সদস্য সফলভাবে বিনিয়োগ করলে, নগদ বোনাস তাৎক্ষণিকভাবে আপনার অ্যাকাউন্ট ব্যালেন্সে জমা হয়ে যাবে এবং আপনি তাৎক্ষণিকভাবে তা তুলতে পারবেন।</p>
            </div>
        </div>
    </main>

    <footer class="bottom-nav">
        <a href="{{ url('home') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-home"></i></div>
            <span>হোম</span>
        </a>
        <a href="{{ url('ordered') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-store"></i></div>
            <span>আমার খনন</span>
        </a>
        <a href="{{ url('my-team') }}" class="nav-item active">
            <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
            <span>আমন্ত্রণ</span>
        </a>
        <a href="{{ url('profile') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-user"></i></div>
            <span>আমার</span>
        </a>
    </footer>

    <script>
        function showNotification(message) {
            const notification = document.getElementById('notification');
            notification.textContent = message;
            notification.classList.add('show');
            
            setTimeout(() => {
                notification.classList.remove('show');
            }, 3000);
        }

        function copyLink(text, type = 'Text') {
            navigator.clipboard.writeText(text).then(() => {
                showNotification('✓ ' + type + ' কপি করা হয়েছে!');
            }).catch(err => {
                showNotification('❌ কপি করতে ব্যর্থ হয়েছে!');
            });
        }

        // Add hover effects to all interactive elements
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.stat-card, .qr-section, .invite-box, .rules');
            
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-3px)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            // Add click effects to buttons
            const buttons = document.querySelectorAll('.copy-link-btn, .copy-btn');
            buttons.forEach(btn => {
                btn.addEventListener('click', function() {
                    this.style.transform = 'scale(0.95)';
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 150);
                });
            });
        });
    </script>
</body>
</html>