<!doctype html>
<html lang="bn">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <title>BMF - লেনদেনের রেকর্ড</title>
    <!-- External Stylesheets -->
    <link rel="icon" href="/site/1176026229.jpg" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        /* General Styles */
        body {
            background-color: var(--primary-bg);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--text-primary);
            margin: 0;
            padding-bottom: 80px; /* Footer height */
        }

        main {
            max-width: 500px;
            margin: auto;
        }
        
        /* Empty State Message */
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: var(--text-muted);
            background: var(--card-bg);
            margin: 20px;
            border-radius: var(--border-radius);
            border: 1px solid var(--border-color);
            transition: var(--transition);
        }

        .empty-state:hover {
            transform: translateY(-3px);
            box-shadow: var(--box-shadow);
        }

        /* Navbar Styles */
        .navbar {
            background: var(--secondary-bg);
            color: var(--accent-gold);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
            padding: 16px 20px;
            position: sticky;
            top: 0;
            z-index: 100;
            display: flex;
            justify-content: center;
            align-items: center;
            border-bottom: 1px solid var(--border-color);
        }

        .navbar .left a {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--accent-gold);
            font-size: 16px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 12px;
            border-radius: 8px;
            transition: var(--transition);
        }

        .navbar .left a:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: translateY(-50%) scale(1.05);
        }

        .navbar .center {
            font-weight: 700;
            font-size: 18px;
            color: var(--accent-gold);
        }
        
        /* Filter Menu Styles */
        .filter-menu {
            display: flex;
            justify-content: space-around;
            padding: 15px;
            background-color: var(--secondary-bg);
            border-bottom: 1px solid var(--border-color);
            gap: 8px;
        }

        .filter-menu-item {
            padding: 10px 16px;
            border: 1px solid var(--border-color);
            background-color: var(--card-bg);
            color: var(--text-secondary);
            cursor: pointer;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            transition: var(--transition);
            flex: 1;
            text-align: center;
            min-width: 0;
        }

        .filter-menu-item:hover {
            background: rgba(255, 215, 0, 0.1);
            color: var(--text-primary);
            border-color: var(--accent-gold);
        }

        .filter-menu-item.light {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            border-color: var(--accent-gold);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }

        /* Statement Card Styles */
        .statement-card {
            background: var(--card-bg);
            border-left: 4px solid var(--accent-gold);
            padding: 18px 16px;
            margin: 0 14px 14px;
            box-shadow: var(--box-shadow);
            line-height: 1.8em;
            border-radius: 0 12px 12px 0;
            border: 1px solid var(--border-color);
            border-left: 4px solid var(--accent-gold);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .statement-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: var(--accent-gold);
        }

        .statement-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
            border-color: var(--accent-gold);
        }

        .statement-row {
            display: flex;
            justify-content: space-between;
            padding: 6px 0;
            font-size: 14px;
            align-items: center;
        }

        .statement-row strong {
            color: var(--text-primary);
            font-weight: 600;
            min-width: 120px;
        }
        
        .statement-row span {
            color: var(--text-secondary);
            text-align: right;
            flex: 1;
        }
        
        .statement-row .amount {
            font-weight: 700;
            font-size: 15px;
        }
        
        .amount.positive { 
            color: var(--accent-gold); 
        }
        .amount.negative { 
            color: #ff6b6b; 
        }

        /* Badge Styles */
        .badge {
            display: inline-block;
            padding: 6px 12px;
            font-size: 12px;
            font-weight: 600;
            border-radius: 20px;
            text-transform: capitalize;
            transition: var(--transition);
        }

        .status-success { 
            background: rgba(40, 167, 69, 0.2); 
            color: #28a745; 
            border: 1px solid rgba(40, 167, 69, 0.3);
        }
        .status-pending { 
            background: rgba(255, 193, 7, 0.2); 
            color: #ffc107; 
            border: 1px solid rgba(255, 193, 7, 0.3);
        }
        .status-failed { 
            background: rgba(220, 53, 69, 0.2); 
            color: #dc3545; 
            border: 1px solid rgba(220, 53, 69, 0.3);
        }

        .badge:hover {
            transform: scale(1.05);
        }

        /* Transaction Type Icons */
        .transaction-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 12px;
            background: rgba(255, 215, 0, 0.1);
            color: var(--accent-gold);
            font-size: 16px;
        }

        .transaction-header {
            display: flex;
            align-items: center;
            margin-bottom: 12px;
            padding-bottom: 12px;
            border-bottom: 1px solid var(--border-color);
        }

        .transaction-type {
            font-weight: 600;
            color: var(--accent-gold);
            font-size: 16px;
        }

        /* Footer Styles */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            display: flex;
            justify-content: space-around;
            background: var(--secondary-bg);
            border-top: 1px solid var(--border-color);
            padding: 12px 0;
            z-index: 1000;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
        }

        .nav-item { 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            text-decoration: none; 
            color: var(--text-muted); 
            font-size: 12px; 
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }

        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }

        .nav-item.active span { 
            color: var(--accent-gold); 
            font-weight: 600;
        }
        
        .nav-item.active .icon-wrap { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }
        
        .nav-item i { 
            font-size: 18px; 
        }
        
        .nav-item .icon-wrap { 
            width: 40px; 
            height: 40px; 
            border-radius: 10px; 
            display: flex; 
            justify-content: center; 
            align-items: center; 
            margin-bottom: 5px; 
            transition: var(--transition);
            background: var(--card-bg);
        }

        /* Scrollbar styling */
        ::-webkit-scrollbar {
            width: 6px;
        }
        
        ::-webkit-scrollbar-track {
            background: var(--secondary-bg);
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--accent-gold);
            border-radius: 3px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: var(--accent-gold-light);
        }

        /* Responsive adjustments */
        @media (max-width: 480px) {
            .filter-menu {
                padding: 12px 10px;
                gap: 6px;
            }
            
            .filter-menu-item {
                padding: 8px 12px;
                font-size: 13px;
            }
            
            .statement-card {
                margin: 0 10px 12px;
                padding: 15px 12px;
            }
            
            .statement-row {
                font-size: 13px;
            }
            
            .statement-row strong {
                min-width: 100px;
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }

        @media (max-width: 360px) {
            .filter-menu {
                flex-wrap: wrap;
            }
            
            .filter-menu-item {
                flex: 1 0 45%;
                margin-bottom: 5px;
            }
            
            .statement-row {
                flex-direction: column;
                align-items: flex-start;
                gap: 2px;
            }
            
            .statement-row span {
                text-align: left;
            }
        }
    </style>
</head>

<body>
    <main>
        <div class="navbar">
            <div class="left"><a href="{{ route('profile') }}"><i class="fas fa-arrow-left"></i> ফিরে যান</a></div>
            <div class="center"><i class="fas fa-history me-2"></i>লেনদেনের রেকর্ড</div>
        </div>

        <div class="filter-menu">
            <div class="filter-menu-item light" onclick="tabMenu(this, 'all')">
                <i class="fas fa-list me-1"></i>সব
            </div>
            <div class="filter-menu-item" onclick="tabMenu(this, 'withdraw')">
                <i class="fas fa-arrow-up me-1"></i>উত্তোলন
            </div>
            <div class="filter-menu-item" onclick="tabMenu(this, 'deposit')">
                <i class="fas fa-download me-1"></i>রিচার্জ
            </div>
            <div class="filter-menu-item" onclick="tabMenu(this, 'reward')">
                <i class="fas fa-gift me-1"></i>পুরস্কার
            </div>
        </div>

        <div class="p-2">
            <!-- All History (সব ধরনের লেনদেন) -->
            <div class="history-group all">
                @php
                    // কন্ট্রোলারে এই ডেটা প্রস্তুত করা সবচেয়ে ভালো এবং দ্রুততর
                    $deposits = \App\Models\Deposit::where('user_id', user()->id)->get()->map(function($item) {
                        $item->record_type = 'রিচার্জ';
                        $item->order_id_unified = $item->order_id;
                        $item->icon = 'fa-download';
                        return $item;
                    });
                    $withdrawals = \App\Models\Withdrawal::where('user_id', user()->id)->get()->map(function($item) {
                        $item->record_type = 'উত্তোলন';
                        $item->order_id_unified = $item->oid;
                        $item->icon = 'fa-arrow-up';
                        return $item;
                    });
                    $rewards = \App\Models\UserLedger::where('user_id', user()->id)->where('amount', '>', 0)->get()->map(function($item) {
                        $item->record_type = 'পুরস্কার';
                        $item->status = 'approved'; // লেজার এন্ট্রি সাধারণত সফল হয়
                        $item->icon = 'fa-gift';
                        return $item;
                    });

                    $all_history = collect($deposits)->concat($withdrawals)->concat($rewards)->sortByDesc('created_at');
                @endphp

                @forelse($all_history as $element)
                    <div class="statement-card">
                        <div class="transaction-header">
                            <div class="transaction-icon">
                                <i class="fas {{ $element->icon }}"></i>
                            </div>
                            <div class="transaction-type">{{ $element->record_type }}</div>
                        </div>
                        
                        @if($element->record_type == 'পুরস্কার')
                            <div class="statement-row"><strong>বিবরণ</strong><span>{{ $element->reason }}</span></div>
                        @else
                            <div class="statement-row"><strong>অর্ডার নং</strong><span>{{ $element->order_id_unified }}</span></div>
                        @endif

                        <div class="statement-row"><strong>টাকার পরিমাণ</strong><span class="amount {{ $element->amount >= 0 ? 'positive' : 'negative' }}">৳ {{ number_format($element->amount, 2) }}</span></div>
                        
                        <div class="statement-row">
                            <strong>স্ট্যাটাস</strong>
                            <span class="badge @if($element->status == 'approved') status-success @elseif($element->status == 'rejected') status-failed @else status-pending @endif">
                                @if($element->status == 'rejected') ব্যর্থ @elseif($element->status == 'approved') সফল @else প্রক্রিয়াধীন @endif
                            </span>
                        </div>
                        <div class="statement-row"><strong>তারিখ</strong><span>{{ $element->created_at->format('d M Y, h:i A') }}</span></div>
                    </div>
                @empty
                    <div class="empty-state">
                        <i class="fas fa-receipt" style="font-size: 48px; margin-bottom: 15px; color: var(--accent-gold);"></i>
                        <br>
                        কোনো লেনদেনের রেকর্ড নেই।
                    </div>
                @endforelse
            </div>

            <!-- Withdraw History (শুধুমাত্র উত্তোলন) -->
            <div class="history-group withdraw" style="display: none;">
                 @forelse(\App\Models\Withdrawal::where('user_id', user()->id)->orderByDesc('id')->get() as $element)
                    <div class="statement-card">
                        <div class="transaction-header">
                            <div class="transaction-icon">
                                <i class="fas fa-arrow-up"></i>
                            </div>
                            <div class="transaction-type">উত্তোলন</div>
                        </div>
                        <div class="statement-row"><strong>অর্ডার নং</strong><span>{{ $element->oid }}</span></div>
                        <div class="statement-row"><strong>টাকার পরিমাণ</strong><span class="amount negative">৳ {{ number_format($element->amount, 2) }}</span></div>
                        <div class="statement-row"><strong>স্ট্যাটাস</strong><span class="badge @if($element->status == 'approved') status-success @elseif($element->status == 'rejected') status-failed @else status-pending @endif">@if($element->status == 'rejected') ব্যর্থ @elseif($element->status == 'approved') সফল @else প্রক্রিয়াধীন @endif</span></div>
                        <div class="statement-row"><strong>তারিখ</strong><span>{{ $element->created_at->format('d M Y, h:i A') }}</span></div>
                    </div>
                 @empty
                    <div class="empty-state">
                        <i class="fas fa-arrow-up" style="font-size: 48px; margin-bottom: 15px; color: var(--accent-gold);"></i>
                        <br>
                        কোনো উত্তোলনের রেকর্ড নেই।
                    </div>
                 @endforelse
            </div>

            <!-- Deposit/Recharge History (শুধুমাত্র রিচার্জ) -->
            <div class="history-group deposit" style="display: none;">
                 @forelse(\App\Models\Deposit::where('user_id', user()->id)->orderByDesc('id')->get() as $element)
                    <div class="statement-card">
                        <div class="transaction-header">
                            <div class="transaction-icon">
                                <i class="fas fa-download"></i>
                            </div>
                            <div class="transaction-type">রিচার্জ</div>
                        </div>
                        <div class="statement-row"><strong>অর্ডার নং</strong><span>{{$element->order_id}}</span></div>
                        <div class="statement-row"><strong>টাকার পরিমাণ</strong><span class="amount positive">৳ {{ number_format($element->amount, 2) }}</span></div>
                        <div class="statement-row"><strong>স্ট্যাটাস</strong><span class="badge @if($element->status == 'approved') status-success @elseif($element->status == 'rejected') status-failed @else status-pending @endif">@if($element->status == 'rejected') ব্যর্থ @elseif($element->status == 'approved') সফল @else প্রক্রিয়াধীন @endif</span></div>
                        <div class="statement-row"><strong>তারিখ</strong><span>{{ $element->created_at->format('d M Y, h:i A') }}</span></div>
                    </div>
                @empty
                    <div class="empty-state">
                        <i class="fas fa-download" style="font-size: 48px; margin-bottom: 15px; color: var(--accent-gold);"></i>
                        <br>
                        কোনো রিচার্জের রেকর্ড নেই।
                    </div>
                @endforelse
            </div>

            <!-- Reward History (বোনাস, কমিশন, আয় ইত্যাদি) -->
            <div class="history-group reward" style="display: none;">
                 @php
                    $rewards = \App\Models\UserLedger::where('user_id', auth()->id())->where('amount', '>', 0)->orderByDesc('id')->get();
                @endphp
                @forelse($rewards as $element)
                    <div class="statement-card">
                        <div class="transaction-header">
                            <div class="transaction-icon">
                                <i class="fas fa-gift"></i>
                            </div>
                            <div class="transaction-type">পুরস্কার</div>
                        </div>
                        <div class="statement-row"><strong>বিবরণ</strong><span>{{ $element->reason }}</span></div>
                        <div class="statement-row"><strong>টাকার পরিমাণ</strong><span class="amount positive">৳ {{ number_format($element->amount, 2) }}</span></div>
                        <div class="statement-row"><strong>স্ট্যাটাস</strong><span class="badge status-success">সফল</span></div>
                        <div class="statement-row"><strong>তারিখ</strong><span>{{ $element->created_at->format('d M Y, h:i A') }}</span></div>
                    </div>
                @empty
                    <div class="empty-state">
                        <i class="fas fa-gift" style="font-size: 48px; margin-bottom: 15px; color: var(--accent-gold);"></i>
                        <br>
                        এখনও কোনো পুরস্কারের রেকর্ড নেই।
                    </div>
                @endforelse
            </div>
        </div>
    </main>

    <footer class="bottom-nav">
        <a href="{{ url('home') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-home"></i></div>
            <span>হোম</span>
        </a>
        <a href="{{ url('ordered') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-store"></i></div>
            <span>আমার খনন</span>
        </a>
        <a href="{{ url('my-team') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
            <span>আমন্ত্রণ</span>
        </a>
        <a href="{{ url('profile') }}" class="nav-item active">
            <div class="icon-wrap"><i class="fas fa-user"></i></div>
            <span>আমার</span>
        </a>
    </footer>

    <!-- Scripts -->
    <script>
        function tabMenu(_this, menuType) {
            var menuItems = document.querySelectorAll('.filter-menu-item');
            menuItems.forEach(item => item.classList.remove('light'));
            _this.classList.add('light');
            document.querySelectorAll('.history-group').forEach(group => group.style.display = 'none');
            document.querySelector('.' + menuType).style.display = 'block';
        }

        // Add interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.statement-card');
            
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-3px)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            const badges = document.querySelectorAll('.badge');
            badges.forEach(badge => {
                badge.addEventListener('mouseenter', function() {
                    this.style.transform = 'scale(1.05)';
                });
                
                badge.addEventListener('mouseleave', function() {
                    this.style.transform = 'scale(1)';
                });
            });
        });
    </script>
</body>
</html>