<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>History</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css">
    <style>

        * {
            padding: 0;
            margin: 0;
        }

        body {
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
            font-size: 14px;
            line-height: 1.42857143;
            color: #333;
            background-color: #eef0f3;
        }

        #exTab1 .tab-content {
            color: white;
            background-color: #428bca;
            padding: 5px 15px;
        }

        #exTab2 h3 {
            color: white;
            background-color: #428bca;
            padding: 5px 15px;
        }

        /* remove border radius for the tab */

        #exTab1 .nav-pills > li > a {
            border-radius: 0;
        }

        /* change border radius for the tab , apply corners on top*/

        #exTab3 .nav-pills > li > a {
            border-radius: 4px 4px 0 0;
        }

        #exTab3 .tab-content {
            color: white;
            background-color: #428bca;
            padding: 5px 15px;
        }

        a {
            color: #12b888;
            text-decoration: none;
        }

        #exTab3 .tab-content {
            color: white;
            background-color: transparent;
            padding: 5px 15px;
        }

        .nav-pills > li.active > a, .nav-pills > li.active > a:hover, .nav-pills > li.active > a:focus {
            color: #fff;
            background-color: #12b888;
        }

        #exTab3 .tab-content {
            color: white;
            background-color: transparent;
            padding: 5px 0;
        }

        .history_list {
            padding: 5px 15px;
            border-radius: 8px;
            margin-bottom: 10px;
        }

        h5 {
            color: #01ccd6;
            margin: 6px 0;
        }
    </style>
</head>
<body>

<div style="height: 60px;">
    <div style="padding: 15px;display: flex;justify-content: space-between;align-items: center;background: #ffffff;position: fixed;width: 100%;">
        <div><img onclick="window.location.href='{{route('profile')}}'" style="width: 20px;"
                  src="https://img.icons8.com/ios-glyphs/50/chevron-left.png" alt=""></div>
        <div style="color: #12b888;font-size: 20px;">Deposit History</div>
        <div></div>
    </div>
</div>

<div id="exTab3" class="container">

    <div class="tab-content clearfix">
        <div class="tab-pane active" id="1b">
            @foreach(\App\Models\Deposit::where('user_id',  user()->id)->orderByDesc('id')->get() as $element)
            <div class="history_list" style="background: #ffffff;">
                <div style="display: flex;justify-content: space-between;align-items: center;">
                    <div><h5>OrderNo</h5></div>
                    <div><h5>{{$element->order_id}}</h5></div>
                </div>
                <div style="display: flex;justify-content: space-between;align-items: center;">
                    <div><h5>Amount</h5></div>
                    <div><h5>{{price($element->amount)}}</h5></div>
                </div>

                <div style="display: flex;justify-content: space-between;align-items: center;">
                    <div><h5>Time</h5></div>
                    <div><h5>{{$element->created_at}}</h5></div>
                </div>
                <div style="display: flex;justify-content: space-between;align-items: center;">
                    <div><h5>Status</h5></div>
                    <div><h5>
                            @if($element->status == 'rejected')
                                Failed
                            @elseif($element->status == 'approved')
                                Success
                            @else
                                process
                            @endif
                        </h5>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>


<!-- Bootstrap core JavaScript
    ================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>


<script>
    window.onload = function() {
        $.ajax({
            url: '{{url('onepay-payment-checker')}}',
            type: 'GET',
            dataType: 'json',
            success: function(res) {
                console.log(res);
            }
        });
    };

</script>
</body>
</html>
