<!doctype html>
<html lang="zh-CN"
      style="--status-bar-height: 0px; --top-window-height: 0px; --window-left: 0px; --window-right: 0px; --window-margin: 0px; --window-top: calc(var(--top-window-height) + 0px); --window-bottom: 0px;">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>BMF</title>
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">


    <style type="text/css">
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        body {
            background-color: var(--primary-bg);
            color: var(--text-primary);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            padding-bottom: 80px;
            margin: 0;
        }

        .about-section {
            max-width: 500px;
            margin: 20px auto;
            padding: 25px 20px;
            background: var(--card-bg);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            animation: fadeIn 0.4s ease-in-out;
            border: 1px solid var(--border-color);
            position: relative;
        }

        .about-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .about-section h1 {
            font-size: 28px;
            font-weight: bold;
            text-align: center;
            color: var(--accent-gold);
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid var(--border-color);
            position: relative;
        }

        .about-section h1::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 2px;
            background: var(--accent-gold);
        }

        .about-section p {
            font-size: 16px;
            line-height: 1.8;
            margin-bottom: 20px;
            text-align: justify;
            color: var(--text-secondary);
            padding: 0 5px;
            transition: var(--transition);
        }

        .about-section p:hover {
            color: var(--text-primary);
            transform: translateX(5px);
        }

        .about-section p strong {
            color: var(--accent-gold);
            font-weight: 600;
        }

        .about-section img {
            width: 100%;
            height: auto;
            border-radius: 12px;
            margin: 25px 0;
            box-shadow: var(--box-shadow);
            border: 2px solid var(--accent-gold);
            transition: var(--transition);
        }

        .about-section img:hover {
            transform: scale(1.02);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.3);
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin: 30px 0;
        }

        .feature-card {
            background: var(--secondary-bg);
            padding: 20px 15px;
            border-radius: 12px;
            text-align: center;
            border: 1px solid var(--border-color);
            transition: var(--transition);
            cursor: pointer;
        }

        .feature-card:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: translateY(-5px);
            border-color: var(--accent-gold);
            box-shadow: 0 6px 15px rgba(255, 215, 0, 0.2);
        }

        .feature-card i {
            font-size: 32px;
            color: var(--accent-gold);
            margin-bottom: 12px;
            transition: var(--transition);
        }

        .feature-card:hover i {
            transform: scale(1.1);
            color: var(--accent-gold-light);
        }

        .feature-card h3 {
            font-size: 16px;
            color: var(--text-primary);
            margin-bottom: 8px;
            font-weight: 600;
        }

        .feature-card p {
            font-size: 13px;
            color: var(--text-secondary);
            line-height: 1.5;
            margin: 0;
            text-align: center;
        }

        .stats-section {
            display: flex;
            justify-content: space-around;
            margin: 30px 0;
            background: var(--secondary-bg);
            padding: 20px;
            border-radius: 12px;
            border: 1px solid var(--border-color);
        }

        .stat-item {
            text-align: center;
            flex: 1;
        }

        .stat-number {
            font-size: 24px;
            font-weight: bold;
            color: var(--accent-gold);
            margin-bottom: 5px;
        }

        .stat-label {
            font-size: 12px;
            color: var(--text-secondary);
        }

        .contact-info {
            background: var(--secondary-bg);
            padding: 20px;
            border-radius: 12px;
            margin: 25px 0;
            border: 1px solid var(--border-color);
            transition: var(--transition);
        }

        .contact-info:hover {
            border-color: var(--accent-gold);
            transform: translateY(-3px);
        }

        .contact-info h3 {
            color: var(--accent-gold);
            margin-bottom: 15px;
            text-align: center;
            font-size: 18px;
        }

        .contact-item {
            display: flex;
            align-items: center;
            margin-bottom: 12px;
            padding: 8px;
            border-radius: 8px;
            transition: var(--transition);
        }

        .contact-item:hover {
            background: rgba(255, 215, 0, 0.1);
        }

        .contact-item i {
            color: var(--accent-gold);
            margin-right: 12px;
            font-size: 18px;
            width: 20px;
            text-align: center;
        }

        .contact-item span {
            color: var(--text-secondary);
            font-size: 14px;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            display: flex;
            justify-content: space-around;
            background: var(--secondary-bg);
            border-top: 1px solid var(--border-color);
            padding: 12px 0;
            z-index: 1000;
            max-width: 500px;
            margin: auto;
            left: 0;
            right: 0;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
        }

        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: var(--text-muted);
            font-size: 12px;
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }

        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }

        .nav-item .icon-wrap {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 5px;
            transition: var(--transition);
            background: var(--card-bg);
        }

        .nav-item i {
            font-size: 18px;
        }

        .nav-item.active .icon-wrap {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }

        .nav-item.active span {
            color: var(--accent-gold);
            font-weight: 600;
        }

        /* Scrollbar styling */
        ::-webkit-scrollbar {
            width: 6px;
        }
        
        ::-webkit-scrollbar-track {
            background: var(--secondary-bg);
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--accent-gold);
            border-radius: 3px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: var(--accent-gold-light);
        }

        /* Responsive adjustments */
        @media (max-width: 480px) {
            .about-section {
                margin: 15px auto;
                padding: 20px 15px;
            }
            
            .about-section h1 {
                font-size: 24px;
            }
            
            .about-section p {
                font-size: 15px;
            }
            
            .features-grid {
                grid-template-columns: 1fr;
                gap: 12px;
            }
            
            .stats-section {
                padding: 15px;
            }
            
            .stat-number {
                font-size: 20px;
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }
    </style>
</head>
<body class="uni-body pages-article">
<uni-app class="uni-app--maxwidth" style="max-width: 500px; margin: auto;">
    <uni-page>
        <uni-page-wrapper>
            <uni-page-body style="white-space: unset;width: 100%;">
                <main>
                    <div class="about-section">
                        <h1><i class="fas fa-info-circle me-2"></i>আমাদের সম্পর্কে</h1>

                        <p>
                            <strong>{{env('APP_NAME')}}</strong> একটি আধুনিক কৃষি প্রযুক্তি নির্ভর ডিজিটাল প্ল্যাটফর্ম যা খামারিদের জন্য উন্নত উৎপাদন, বিপণন এবং পরামর্শ সেবা প্রদান করে। আমরা কৃষিকে আধুনিকায়নের মাধ্যমে টেকসই ও লাভজনক খামার ব্যবস্থা গড়ে তুলতে কাজ করছি।
                        </p>

                        <p>
                            {{env('APP_NAME')}} প্ল্যাটফর্মের মাধ্যমে কৃষকরা সহজেই বীজ, সার, ও প্রযুক্তিগত সহায়তা পেতে পারেন। একই সাথে, বাজারে পণ্যের ন্যায্য মূল্য পাওয়ার জন্য সরাসরি অনলাইন বিক্রয় এবং চুক্তিভিত্তিক কৃষির সুবিধাও থাকছে।
                        </p>

                        <!-- Features Grid -->
                        <div class="features-grid">
                            <div class="feature-card">
                                <i class="fas fa-seedling"></i>
                                <h3>উন্নত বীজ</h3>
                                <p>উচ্চ ফলনশীল ও রোগ প্রতিরোধী বীজ</p>
                            </div>
                            <div class="feature-card">
                                <i class="fas fa-tractor"></i>
                                <h3>আধুনিক যন্ত্র</h3>
                                <p>আধুনিক কৃষি যন্ত্রপাতির সুবিধা</p>
                            </div>
                            <div class="feature-card">
                                <i class="fas fa-chart-line"></i>
                                <h3>বাজার বিশ্লেষণ</h3>
                                <p>রিয়েল-টাইম বাজার মূল্য ও বিশ্লেষণ</p>
                            </div>
                            <div class="feature-card">
                                <i class="fas fa-headset"></i>
                                <h3>২৪/৭ সহায়তা</h3>
                                <p>বিশেষজ্ঞ পরামর্শ ও টেকনিক্যাল সাপোর্ট</p>
                            </div>
                        </div>

                        <p>
                            আমাদের সেবা অন্তর্ভুক্ত করে আবহাওয়া ভিত্তিক পরামর্শ, বালাই ব্যবস্থাপনা, এবং আধুনিক যন্ত্রপাতি ব্যবহারের নির্দেশনা, যা একজন কৃষককে তার খামারের উৎপাদনশীলতা বাড়াতে সাহায্য করে।{{env('APP_NAME')}} প্রতিটি ধাপে প্রযুক্তির সর্বোচ্চ ব্যবহার নিশ্চিত করে।
                        </p>

                        <!-- Stats Section -->
                        <div class="stats-section">
                            <div class="stat-item">
                                <div class="stat-number">১০,০০০+</div>
                                <div class="stat-label">সক্রিয় কৃষক</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number">৫০+</div>
                                <div class="stat-label">জেলায় সেবা</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number">৯৫%</div>
                                <div class="stat-label">সন্তুষ্টি হার</div>
                            </div>
                        </div>

                        <p>
                            {{env('APP_NAME')}} এর প্রযুক্তিগত অবকাঠামো উন্নত ফার্ম ম্যানেজমেন্ট সফটওয়্যার এবং AI ভিত্তিক বিশ্লেষণ টুলের মাধ্যমে পরিচালিত হয়, যা খামারের তথ্য বিশ্লেষণ করে বুদ্ধিমত্তাভিত্তিক সিদ্ধান্ত গ্রহণে সহায়তা করে। আমাদের দক্ষ পরামর্শক দল ২৪/৭ সহায়তা নিয়ে কৃষকের পাশে আছে।
                        </p>

                        <!-- Contact Information -->
                        <div class="contact-info">
                            <h3><i class="fas fa-address-card me-2"></i>যোগাযোগ তথ্য</h3>
                            <div class="contact-item">
                                <i class="fas fa-phone"></i>
                                <span>+৮৮০ ১৬XX-XXXXXX</span>
                            </div>
                            <div class="contact-item">
                                <i class="fas fa-envelope"></i>
                                <span>support@codekartlab.site</span>
                            </div>
                            <div class="contact-item">
                                <i class="fas fa-map-marker-alt"></i>
                                <span>ঢাকা, বাংলাদেশ</span>
                            </div>
                            <div class="contact-item">
                                <i class="fas fa-clock"></i>
                                <span>সকাল ৯টা - রাত ১০টা</span>
                            </div>
                        </div>
                    </div>
                </main>
            </uni-page-body>
        </uni-page-wrapper>
    </uni-page>
</uni-app>

<footer class="bottom-nav">
    <a href="{{ url('home') }}" class="nav-item">
        <div class="icon-wrap"><i class="fas fa-home"></i></div>
        <span>হোম</span>
    </a>
    <a href="{{ url('ordered') }}" class="nav-item">
        <div class="icon-wrap"><i class="fas fa-store"></i></div>
        <span>আমার খনন</span>
    </a>
    <a href="{{ url('invite') }}" class="nav-item">
        <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
        <span>আমন্ত্রণ</span>
    </a>
    <a href="{{ url('profile') }}" class="nav-item active">
        <div class="icon-wrap"><i class="fas fa-user"></i></div>
        <span>আমার</span>
    </a>
</footer>

<script>
    // Add interactive effects
    document.addEventListener('DOMContentLoaded', function() {
        // Add hover effects to feature cards
        const featureCards = document.querySelectorAll('.feature-card');
        featureCards.forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-5px)';
            });
            
            card.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });

        // Add hover effects to contact items
        const contactItems = document.querySelectorAll('.contact-item');
        contactItems.forEach(item => {
            item.addEventListener('mouseenter', function() {
                this.style.background = 'rgba(255, 215, 0, 0.1)';
            });
            
            item.addEventListener('mouseleave', function() {
                this.style.background = 'transparent';
            });
        });

        // Add scroll animation for paragraphs
        const paragraphs = document.querySelectorAll('.about-section p');
        paragraphs.forEach(p => {
            p.addEventListener('mouseenter', function() {
                this.style.transform = 'translateX(5px)';
                this.style.color = 'var(--text-primary)';
            });
            
            p.addEventListener('mouseleave', function() {
                this.style.transform = 'translateX(0)';
                this.style.color = 'var(--text-secondary)';
            });
        });
    });
</script>

</body>
</html>