<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, viewport-fit=cover">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{env('APP_NAME')}}</title>
    <link rel="icon" href="{{asset(setting('photo', '/CodeKartLab/main-logo.png'))}}" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        html, body { 
            height: 100%; 
            width: 100%; 
            overflow-y: auto; 
            background-color: var(--primary-bg); 
            font-family: 'Noto Sans Bengali', sans-serif; 
            color: var(--text-primary); 
        }
        main { 
            display: flex; 
            justify-content: center; 
            align-items: center; 
            min-height: 100vh;
            width: 100%; 
            padding: 15px; 
        }
        .container { 
            background-color: var(--card-bg); 
            border-radius: 12px; 
            padding: 25px 20px; 
            width: 100%; 
            max-width: 400px; 
            position: relative; 
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.4); 
            border: 1px solid var(--border-color);
        }
        .back-button { 
            position: absolute; 
            top: 10px; 
            left: 15px; 
            background: none; 
            border: none; 
            color: var(--accent-gold); 
            font-size: 24px; 
            cursor: pointer; 
            z-index: 10; 
        }
        .title { 
            text-align: center; 
            margin-top: 25px; 
            font-size: 26px; 
            color: var(--accent-gold);
        }
        .logo { 
            text-align: center; 
            margin-bottom: 20px; 
        }
        .logo img { 
            width: 90px; 
            height: 90px; 
            border-radius: 50%; 
            border: 2px solid var(--accent-gold);
        }
        .input-box { 
            display: flex; 
            align-items: center; 
            background-color: var(--secondary-bg); 
            border-radius: 8px; 
            margin-bottom: 15px; 
            border: 1px solid var(--border-color); 
            overflow: hidden; 
        }
        .input-box .left { 
            color: var(--accent-gold); 
            font-weight: 600; 
            padding: 12px; 
            border-right: 1px solid var(--border-color); 
            margin-right: 12px; 
            min-width: 120px; 
            text-align: center; 
            font-size: 14px; 
        }
        .input-box input { 
            border: none; 
            background: none; 
            flex: 1; 
            padding: 12px 10px 12px 0; 
            color: var(--text-primary); 
            font-size: 14px; 
            width: 100%; 
        }
        .input-box input:focus { 
            outline: none; 
        }
        .input-box input::placeholder {
            color: var(--text-muted);
        }
        .submit-btn { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: black; 
            padding: 12px; 
            width: 100%; 
            border: none; 
            border-radius: 25px; 
            font-size: 16px; 
            font-weight: bold; 
            margin-top: 20px; 
            cursor: pointer; 
            transition: all 0.3s ease; 
        }
        .submit-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
        }
        .submit-btn:disabled { 
            background-color: var(--text-muted); 
            color: var(--text-secondary); 
            cursor: not-allowed; 
            transform: none;
        }
        .footer-text { 
            text-align: center; 
            margin-top: 20px; 
            font-size: 14px; 
            color: var(--text-secondary);
        }
        .footer-text a { 
            color: var(--accent-gold); 
            text-decoration: none; 
            font-weight: bold; 
        }
        .captcha-container { 
            display: flex; 
            gap: 10px; 
            margin-bottom: 15px; 
        }
        .captcha-code { 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            background-color: var(--secondary-bg); 
            padding: 0 15px; 
            border-radius: 8px; 
            font-weight: bold; 
            letter-spacing: 4px; 
            font-size: 18px; 
            user-select: none; 
            text-decoration: line-through; 
            text-decoration-color: var(--text-muted); 
            color: var(--accent-gold); 
            flex: 1; 
            border: 1px solid var(--border-color);
        }
        .refresh-captcha { 
            color: var(--accent-gold); 
            font-size: 20px; 
            cursor: pointer; 
            background: none; 
            border: none; 
            padding: 0 10px; 
            transition: all 0.3s ease;
        }
        .refresh-captcha:hover {
            color: var(--accent-gold-light);
            transform: rotate(90deg);
        }
        .captcha-input { 
            flex: 2; 
        }
        .notification-box { 
            position: fixed; 
            top: 20px; 
            left: 50%; 
            transform: translateX(-50%); 
            background: var(--secondary-bg); 
            padding: 15px 25px; 
            border: 2px solid var(--accent-gold); 
            font-size: 16px; 
            font-weight: 500; 
            color: var(--text-primary); 
            border-radius: 10px; 
            z-index: 9999; 
            text-align: center; 
            min-width: 280px; 
            max-width: 90%; 
            box-shadow: 0 4px 20px rgba(0,0,0,0.5); 
            animation: slideDown 0.5s ease, fadeOut 0.5s ease 3.5s forwards; 
        }
        .success-notification { 
            border-color: #4CAF50; 
        }
        .warning-notification { 
            border-color: var(--accent-gold); 
        }
        @keyframes slideDown { 
            from { opacity: 0; top: -50px; } 
            to { opacity: 1; top: 20px; } 
        }
        @keyframes fadeOut { 
            to { opacity: 0; top: -50px; } 
        }

        /* Mobile optimization */
        @media (max-width: 480px) {
            main {
                min-height: 100vh;
                padding: 10px;
                align-items: flex-start;
                padding-top: 20px;
            }
            .container {
                margin: 0;
                padding: 20px 15px;
            }
            .title {
                font-size: 22px;
                margin-top: 20px;
            }
            .logo img {
                width: 80px;
                height: 80px;
            }
            .input-box .left {
                min-width: 100px;
                padding: 10px;
                font-size: 13px;
            }
            .input-box input {
                padding: 10px 8px 10px 0;
                font-size: 13px;
            }
            .captcha-container {
                flex-direction: column;
                gap: 8px;
            }
            .captcha-code {
                padding: 10px;
                font-size: 16px;
                order: 1;
            }
            .refresh-captcha {
                order: 2;
                align-self: center;
                padding: 8px;
            }
            .captcha-input {
                order: 3;
                flex: none;
            }
            .submit-btn {
                padding: 14px;
                font-size: 15px;
            }
        }

        @media (max-width: 360px) {
            .container {
                padding: 15px 12px;
            }
            .title {
                font-size: 20px;
            }
            .input-box .left {
                min-width: 90px;
                padding: 8px;
                font-size: 12px;
            }
            .input-box input {
                padding: 8px 6px 8px 0;
                font-size: 12px;
            }
        }

        /* Support for mobile browsers */
        @supports (height: 100dvh) {
            html, body {
                height: 100dvh;
            }
            main {
                min-height: 100dvh;
            }
        }
    </style>
</head>
<body>
    <main>
        <div class="container">
            <button class="back-button" onclick="history.back()">←</button>
            <h1 class="title">নতুন অ্যাকাউন্ট তৈরি করুন</h1>
            <div class="logo"><img src="/CodeKartLab/main-logo.png" alt="Logo"></div>

            
            <form id="registerForm" action="{{ url('register') }}" method="POST" class="form">
                @csrf
                <div class="input-box"><div class="left">ফোন</div><input type="tel" name="phone" placeholder="আপনার ফোন নম্বর" required></div>
                <div class="input-box"><div class="left">ব্যবহারকারী</div><input type="text" name="username" placeholder="একটি ব্যবহারকারীর নাম দিন"></div>
                <div class="input-box"><div class="left">পাসওয়ার্ড</div><input type="password" name="password" placeholder="একটি পাসওয়ার্ড দিন" required></div>
                <div class="input-box"><div class="left">কনফার্ম পাসওয়ার্ড</div><input type="password" name="password_confirmation" placeholder="পুনরায় লিখুন" required></div>
                <div class="input-box"><div class="left">রেফার কোড</div><input type="text" name="ref_by" placeholder="যদি থাকে" value="{{ old('ref_by', $ref_by ?? '') }}"></div>
                <div class="captcha-container">
                    <div class="captcha-code" id="code-box"></div>
                    <button type="button" class="refresh-captcha" id="refresh-captcha" title="নতুন কোড নিন"><i class="fas fa-sync-alt"></i></button>
                    <div class="input-box captcha-input"><input type="text" name="verify_input" placeholder="কোডটি লিখুন" required style="text-transform: uppercase;"></div>
                </div>
                <button type="submit" id="submitBtn" class="submit-btn">নিবন্ধন করুন</button>
            </form>
            <p class="footer-text">আপনার কি অ্যাকাউন্ট আছে? <a href="{{ url('/login') }}">লগইন করুন</a></p>
        </div>
    </main>

 
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('registerForm');
            const submitBtn = document.getElementById('submitBtn');
            const codeBox = document.getElementById('code-box');
            const refreshBtn = document.getElementById('refresh-captcha');
            let correctCode = '';

            function generateCaptcha() {
                const chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
                let captcha = '';
                for (let i = 0; i < 5; i++) captcha += chars.charAt(Math.floor(Math.random() * chars.length));
                codeBox.textContent = captcha;
                correctCode = captcha;
            }

            function showNotification(message, type = 'warning') {
                const existingNotif = document.querySelector('.notification-box');
                if (existingNotif) existingNotif.remove();
                const notification = document.createElement('div');
                notification.className = `notification-box ${type === 'success' ? 'success-notification' : 'warning-notification'}`;
                notification.innerHTML = message;
                document.body.appendChild(notification);
            }

            
            function validateAndSubmit(event) {
                
                if (form.querySelector('input[name="password"]').value !== form.querySelector('input[name="password_confirmation"]').value) {
                    event.preventDefault(); 
                    showNotification('দুটি পাসওয়ার্ড মেলেনি। আবার চেষ্টা করুন।');
                    return;
                }
                if (form.querySelector('input[name="verify_input"]').value.toUpperCase() !== correctCode) {
                    event.preventDefault(); 
                    showNotification('ভেরিফিকেশন কোড সঠিক নয়।');
                    generateCaptcha();
                    return;
                }
                
               
                submitBtn.disabled = true;
                submitBtn.textContent = 'অপেক্ষা করুন...';
            }
            
            form.addEventListener('submit', validateAndSubmit);
            refreshBtn.addEventListener('click', generateCaptcha);
            generateCaptcha();

           
            @if ($errors->any())
                showNotification("{!! implode('<br>', $errors->all()) !!}", 'warning');
            @endif
            @if(session('message'))
                showNotification("{{ session('message') }}", 'warning');
            @endif

            // Mobile viewport height fix
            function setVH() {
                let vh = window.innerHeight * 0.01;
                document.documentElement.style.setProperty('--vh', `${vh}px`);
            }
            
            setVH();
            window.addEventListener('resize', setVH);
            window.addEventListener('orientationchange', setVH);
        });
    </script>
</body>
</html>