<!doctype html>
<html lang="bn" data-dpr="1" style="font-size: 38.1px;">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0">
    <title>{{env('APP_NAME')}} - পাসওয়ার্ড পরিবর্তন</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: var(--primary-bg);
            font-family: 'Noto Sans Bengali', sans-serif;
            color: var(--text-primary);
            font-size: 12px;
            padding-bottom: 1.33333rem;
        }

        #app {
            max-width: 500px;
            margin: 0 auto;
            background: var(--primary-bg);
        }

        .basic_wrap {
            background: var(--primary-bg);
        }

        .red_top_bg {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            background: var(--secondary-bg);
            border-bottom: 1px solid var(--border-color);
            position: relative;
        }

        .back_left {
            width: 30px;
            height: 30px;
            background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%23ffd700'%3E%3Cpath d='M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z'/%3E%3C/svg%3E") no-repeat center;
            background-size: contain;
            cursor: pointer;
            transition: var(--transition);
        }

        .back_left:hover {
            transform: translateX(-3px);
        }

        .big_tit {
            flex: 1;
            text-align: center;
            font-size: 18px;
            font-weight: 700;
            color: var(--accent-gold);
        }

        .wrap {
            padding: 20px;
        }

        .title {
            text-align: center;
            margin-bottom: 25px;
        }

        .title p {
            font-size: 20px;
            font-weight: 600;
            color: var(--text-primary);
            margin: 0;
        }

        .bd_tel {
            text-align: center;
            color: var(--text-secondary);
            margin-bottom: 20px;
            padding: 12px;
            background: var(--secondary-bg);
            border-radius: 10px;
            border: 1px solid var(--border-color);
            font-size: 14px;
        }

        .write_box {
            position: relative;
            margin-bottom: 20px;
        }

        .write_box input {
            width: 100%;
            padding: 16px 50px 16px 15px;
            background: var(--secondary-bg);
            border: 2px solid var(--border-color);
            border-radius: 12px;
            color: var(--text-primary);
            font-size: 15px;
            font-family: 'Noto Sans Bengali', sans-serif;
            transition: var(--transition);
        }

        .write_box input:focus {
            outline: none;
            border-color: var(--accent-gold);
            box-shadow: 0 0 0 3px rgba(255, 215, 0, 0.1);
        }

        .write_box input::placeholder {
            color: var(--text-muted);
        }

        .eye_bi {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            width: 24px;
            height: 24px;
            background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%23ffd700'%3E%3Cpath d='M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z'/%3E%3C/svg%3E") no-repeat center;
            background-size: contain;
            cursor: pointer;
            transition: var(--transition);
        }

        .eye_bi:hover {
            transform: translateY(-50%) scale(1.1);
        }

        .write_new_pwd {
            margin-top: 10px;
        }

        .basic_btn {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            text-align: center;
            padding: 18px;
            margin: 30px 20px 20px;
            border-radius: 12px;
            font-weight: 700;
            font-size: 16px;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
            border: none;
            font-family: 'Noto Sans Bengali', sans-serif;
        }

        .basic_btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 215, 0, 0.4);
        }

        .basic_btn:active {
            transform: translateY(0);
        }

        /* Alert Message Styling */
        .alert-message {
            padding: 15px 20px;
            margin: 10px 20px;
            border-radius: 10px;
            font-weight: 600;
            text-align: center;
            border: 1px solid transparent;
        }

        .alert-success {
            background: rgba(76, 175, 80, 0.1);
            color: #4CAF50;
            border-color: #4CAF50;
        }

        .alert-error {
            background: rgba(244, 67, 54, 0.1);
            color: #f44336;
            border-color: #f44336;
        }

        .alert-warning {
            background: rgba(255, 193, 7, 0.1);
            color: var(--accent-gold);
            border-color: var(--accent-gold);
        }

        @media (max-width: 480px) {
            .wrap {
                padding: 15px;
            }
            
            .title p {
                font-size: 18px;
            }
            
            .big_tit {
                font-size: 16px;
            }
            
            .write_box input {
                padding: 14px 45px 14px 12px;
                font-size: 14px;
            }
            
            .basic_btn {
                margin: 25px 15px 15px;
                padding: 16px;
                font-size: 15px;
            }
            
            .bd_tel {
                font-size: 13px;
                padding: 10px;
            }
        }

        /* Loading state */
        .loading {
            opacity: 0.7;
            pointer-events: none;
        }
    </style>
</head>
<body>
<div id="app">
    @include('alert-message')
    <form action="{{route('user.change.password.confirmation')}}" method="post">
        @csrf
        <div class="basic_wrap">
            <div class="red_top_bg">
                <div class="back_left" onclick="window.location.href='{{route('profile')}}'"></div>
                <div class="big_tit">লগইন পাসওয়ার্ড</div>
            </div>
            <div class="wrap">
                <div class="title">
                    <p>লগইন পাসওয়ার্ড পরিবর্তন করুন</p>
                </div>
                
                <p class="bd_tel">
                    <i class="fas fa-phone" style="margin-right: 8px;"></i>
                    সংযুক্ত ফোন নম্বর: {{user()->phone}}
                </p>
                
                <div class="write_box">
                    <input placeholder="বর্তমান পাসওয়ার্ড" name="old_password" id="old_password" type="password">
                    <div class="eye_bi" onclick="eye('old_password')"></div>
                </div>
                
                <div class="write_new_pwd">
                    <div class="write_box">
                        <input placeholder="নতুন পাসওয়ার্ড" name="new_password" id="new_password" type="password">
                        <div class="eye_bi" onclick="eye('new_password')"></div>
                    </div>
                    <div class="write_box">
                        <input placeholder="নতুন পাসওয়ার্ড নিশ্চিত করুন" name="confirm_password" id="confirm_password" type="password">
                        <div class="eye_bi" onclick="eye('confirm_password')"></div>
                    </div>
                </div>
            </div>
            <div class="basic_btn" onclick="passwordChange()">
                <i class="fas fa-save" style="margin-right: 8px;"></i>
                পরিবর্তন করুন
            </div>
        </div>
    </form>
</div>

<script>
    function passwordChange() {
        loading();
        
        // Basic validation
        const oldPassword = document.getElementById('old_password').value;
        const newPassword = document.getElementById('new_password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        
        if (!oldPassword || !newPassword || !confirmPassword) {
            alert('দয়া করে সমস্ত তথ্য পূরণ করুন');
            return;
        }
        
        if (newPassword !== confirmPassword) {
            alert('নতুন পাসওয়ার্ড এবং নিশ্চিতকরণ পাসওয়ার্ড মেলেনি');
            return;
        }
        
        document.querySelector('form').submit();
    }
    
    function eye(id) {
        const pas = document.getElementById(id);
        if (pas.type === 'password') {
            pas.type = 'text';
        } else {
            pas.type = 'password';
        }
    }

    function loading() {
        const btn = document.querySelector('.basic_btn');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin" style="margin-right: 8px;"></i> প্রসেসিং...';
        btn.classList.add('loading');
        
        setTimeout(() => {
            btn.innerHTML = originalText;
            btn.classList.remove('loading');
        }, 3000);
    }

    // Add interactive effects
    document.addEventListener('DOMContentLoaded', function() {
        const inputs = document.querySelectorAll('.write_box input');
        const btn = document.querySelector('.basic_btn');
        
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'translateY(-2px)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'translateY(0)';
            });
        });
        
        btn.addEventListener('mousedown', function() {
            this.style.transform = 'scale(0.98)';
        });
        
        btn.addEventListener('mouseup', function() {
            this.style.transform = '';
        });
    });
</script>
</body>
</html>