<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Login</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">

    <!-- Custom CSS -->
    <style>
        :root {
            --primary: #2d8cff;
            --secondary: #1e5cb3;
            --accent: #00c6ff;
            --dark-bg: #0f172a;
            --darker-bg: #0a0f1c;
            --card-bg: #1e293b;
            --text-light: #f8fafc;
            --text-gray: #94a3b8;
            --border-color: #334155;
        }
        
        body, html {
            height: 100%;
            margin: 0;
            font-family: 'Arial', sans-serif;
            background: linear-gradient(135deg, var(--darker-bg), var(--dark-bg));
            background-attachment: fixed;
            color: var(--text-light);
        }

        .login-container {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 20px;
        }

        .login-box {
            background: var(--card-bg);
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.3);
            padding: 50px 40px;
            max-width: 450px;
            width: 100%;
            position: relative;
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid var(--border-color);
        }

        .login-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.4);
        }

        .login-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--primary), var(--accent));
        }

        .login-header {
            text-align: center;
            margin-bottom: 40px;
        }

        .login-icon {
            font-size: 50px;
            color: var(--primary);
            margin-bottom: 15px;
            text-shadow: 0 0 20px rgba(45, 140, 255, 0.3);
        }

        .login-box h2 {
            margin-bottom: 10px;
            font-weight: bold;
            color: var(--text-light);
            text-align: center;
            font-size: 28px;
        }

        .login-subtitle {
            color: var(--text-gray);
            text-align: center;
            margin-bottom: 30px;
            font-size: 14px;
        }

        .login-box .form-control {
            margin-bottom: 25px;
            border-radius: 12px;
            height: 52px;
            padding: 12px 50px 12px 50px;
            border: 2px solid var(--border-color);
            transition: all 0.3s ease;
            font-size: 15px;
            background: rgba(30, 41, 59, 0.8);
            color: var(--text-light);
        }

        .login-box .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(45, 140, 255, 0.2);
            background: rgba(30, 41, 59, 0.9);
            transform: translateY(-2px);
        }

        .login-box .form-control::placeholder {
            color: var(--text-gray);
        }

        .login-box .btn-primary {
            width: 100%;
            padding: 14px;
            border-radius: 12px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border: none;
            transition: all 0.3s ease;
            font-weight: 600;
            font-size: 16px;
            letter-spacing: 0.5px;
            margin-top: 10px;
            position: relative;
            overflow: hidden;
        }

        .login-box .btn-primary:hover {
            background: linear-gradient(135deg, #1e7eff, #1a52a3);
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(45, 140, 255, 0.3);
        }

        .login-box .btn-primary:active {
            transform: translateY(-1px);
        }

        .login-box .field label {
            font-weight: 600;
            color: var(--text-light);
            margin-bottom: 10px;
            display: block;
            font-size: 14px;
        }

        .input-container {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-gray);
            z-index: 2;
            transition: all 0.3s ease;
        }

        .password-toggle {
            position: absolute;
            right: 18px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--text-gray);
            cursor: pointer;
            z-index: 2;
            width: 22px;
            height: 22px;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0;
            transition: all 0.3s ease;
        }

        .password-toggle:hover {
            color: var(--primary);
            transform: translateY(-50%) scale(1.1);
        }

        .additional-links {
            margin-top: 35px;
            text-align: center;
        }

        .additional-links a {
            display: block;
            margin: 12px 0;
            padding: 14px;
            border-radius: 12px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            text-align: center;
            font-size: 15px;
            position: relative;
            overflow: hidden;
        }

        .btn-hosting {
            background: linear-gradient(135deg, var(--primary), var(--accent));
            color: white;
            box-shadow: 0 4px 15px rgba(45, 140, 255, 0.2);
            border: 1px solid rgba(45, 140, 255, 0.3);
        }

        .btn-hosting:hover {
            background: linear-gradient(135deg, var(--accent), var(--primary));
            color: white;
            text-decoration: none;
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(45, 140, 255, 0.3);
        }

        .btn-telegram {
            background: linear-gradient(135deg, #0088cc, #00aced);
            color: white;
            box-shadow: 0 4px 15px rgba(0, 136, 204, 0.2);
            border: 1px solid rgba(0, 136, 204, 0.3);
        }

        .btn-telegram:hover {
            background: linear-gradient(135deg, #00aced, #0088cc);
            color: white;
            text-decoration: none;
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 136, 204, 0.3);
        }

        .footer-text {
            text-align: center;
            margin-top: 30px;
            font-size: 12px;
            color: var(--text-gray);
            padding-top: 20px;
            border-top: 1px solid var(--border-color);
        }

        .remember-me {
            display: flex;
            align-items: center;
            margin-bottom: 25px;
        }

        .remember-me input {
            margin-right: 10px;
            width: 18px;
            height: 18px;
            accent-color: var(--primary);
        }

        .remember-me label {
            color: var(--text-gray);
            font-size: 14px;
            margin-bottom: 0;
            cursor: pointer;
        }

        .alert {
            border-radius: 12px;
            margin-bottom: 25px;
            display: none;
            padding: 15px 20px;
            border: none;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        .alert-danger {
            background: linear-gradient(135deg, #2a1a1a, #3a1f1f);
            color: #f8d7da;
            border-left: 4px solid #dc3545;
        }

        .alert-success {
            background: linear-gradient(135deg, #1a2a1a, #1f3a1f);
            color: #d4edda;
            border-left: 4px solid #28a745;
        }

        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(10, 15, 28, 0.9);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        .loading-spinner {
            color: var(--primary);
            font-size: 2rem;
            text-align: center;
        }

        .loading-text {
            color: var(--text-light);
            margin-top: 15px;
            font-size: 16px;
        }

        .floating-shapes {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: -1;
        }

        .shape {
            position: absolute;
            border-radius: 50%;
            opacity: 0.05;
            animation: float 20s infinite linear;
            background: var(--primary);
        }

        @keyframes float {
            0% { transform: translate(0, 0) rotate(0deg); }
            33% { transform: translate(30px, -50px) rotate(120deg); }
            66% { transform: translate(-20px, 20px) rotate(240deg); }
            100% { transform: translate(0, 0) rotate(360deg); }
        }

        .stars {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: -2;
        }

        .star {
            position: absolute;
            background: white;
            border-radius: 50%;
            animation: twinkle 5s infinite;
        }

        @keyframes twinkle {
            0%, 100% { opacity: 0.2; }
            50% { opacity: 0.8; }
        }

        @media (max-width: 576px) {
            .login-box {
                padding: 40px 25px;
                margin: 0 10px;
            }
            
            .additional-links a {
                padding: 12px;
                font-size: 14px;
            }
            
            .login-box h2 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

<!-- Stars Background -->
<div class="stars" id="stars"></div>

<!-- Floating Background Shapes -->
<div class="floating-shapes" id="floatingShapes"></div>

<!-- Loading Overlay -->
<div class="loading-overlay" id="loadingOverlay">
    <div class="text-center">
        <div class="loading-spinner">
            <i class="fas fa-spinner fa-spin"></i>
        </div>
        <div class="loading-text">Signing in to Admin Panel...</div>
    </div>
</div>

<div class="login-container">
    <div class="login-box">
        <div class="login-header">
            <div class="login-icon">
                <i class="fas fa-user-shield"></i>
            </div>
            <h2>Admin Login</h2>
            <div class="login-subtitle">
                Secure access to your administration panel
            </div>
        </div>
        
        <!-- Alert Messages -->
        <div class="alert alert-danger" id="errorAlert" role="alert" style="display: none;">
            <i class="fas fa-exclamation-circle"></i> <span id="errorMessage"></span>
        </div>
        
        <div class="alert alert-success" id="successAlert" role="alert" style="display: none;">
            <i class="fas fa-check-circle"></i> <span id="successMessage"></span>
        </div>

        <!-- Simple Form Submission -->
        <form id="admin-login" method="POST" action="{{ route('admin.login-submit') }}">
            @csrf
            <div class="form-group field">
                <label for="email">Email Address</label>
                <div class="input-container">
                    <i class="fas fa-envelope input-icon"></i>
                    <input type="email" name="email" class="form-control" id="email" placeholder="admin@example.com" required value="{{ old('email') }}">
                </div>
            </div>
            <div class="form-group field">
                <label for="password">Password</label>
                <div class="input-container">
                    <i class="fas fa-lock input-icon"></i>
                    <input type="password" name="password" class="form-control" id="password" placeholder="Enter your password" required>
                    <button type="button" class="password-toggle" id="passwordToggle">
                        <i class="fas fa-eye"></i>
                    </button>
                </div>
            </div>
            
            <div class="remember-me">
                <input type="checkbox" id="remember" name="remember" {{ old('remember') ? 'checked' : '' }}>
                <label for="remember">Keep me signed in</label>
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn btn-primary" id="submitBtn">
                    <i class="fas fa-sign-in-alt"></i> Sign In to Dashboard
                </button>
            </div>
        </form>

        <div class="additional-links">
            <a href="https://client.proxhostbd.com/index.php?rp=/store/s" target="_blank" class="btn-hosting">
                <i class="fas fa-server"></i> Get Premium Hosting
            </a>
            <a href="https://t.me/EarningSourceLAB" target="_blank" class="btn-telegram">
                <i class="fab fa-telegram-plane"></i> Join Our Community
            </a>
        </div>

        <div class="footer-text">
            &copy; 2025 Admin Panel. All rights reserved. | Secure Authentication System
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        // Create stars background
        function createStars() {
            const stars = $('#stars');
            for (let i = 0; i < 150; i++) {
                const star = $('<div class="star"></div>');
                const size = Math.random() * 2;
                star.css({
                    width: size + 'px',
                    height: size + 'px',
                    top: Math.random() * 100 + '%',
                    left: Math.random() * 100 + '%',
                    animationDelay: Math.random() * 5 + 's'
                });
                stars.append(star);
            }
        }
        
        // Create floating shapes
        function createFloatingShapes() {
            const container = $('#floatingShapes');
            const colors = ['#2d8cff', '#1e5cb3', '#00c6ff', '#1e90ff'];
            
            for (let i = 0; i < 6; i++) {
                const shape = $('<div class="shape"></div>');
                const size = Math.random() * 80 + 40;
                const color = colors[Math.floor(Math.random() * colors.length)];
                
                shape.css({
                    width: size + 'px',
                    height: size + 'px',
                    background: color,
                    top: Math.random() * 100 + '%',
                    left: Math.random() * 100 + '%',
                    animationDelay: Math.random() * 20 + 's'
                });
                container.append(shape);
            }
        }
        
        createStars();
        createFloatingShapes();
        
        // Password visibility toggle
        $('#passwordToggle').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            const passwordInput = $('#password');
            const currentType = passwordInput.attr('type');
            const newType = currentType === 'password' ? 'text' : 'password';
            
            passwordInput.attr('type', newType);
            
            const icon = $(this).find('i');
            if (newType === 'text') {
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            } else {
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            }
        });

        // Form submission with enhanced UX
        $('#admin-login').on('submit', function(e) {
            const email = $('#email').val().trim();
            const password = $('#password').val();
            
            // Hide previous alerts
            $('#errorAlert').hide();
            $('#successAlert').hide();
            
            // Basic client-side validation
            if (!email || !password) {
                e.preventDefault();
                showError('Please fill in all fields');
                shakeElement($('#admin-login'));
                return false;
            }
            
            if (!isValidEmail(email)) {
                e.preventDefault();
                showError('Please enter a valid email address');
                shakeElement($('#email').closest('.input-container'));
                return false;
            }
            
            // Show loading state but allow form to submit normally
            const submitBtn = $('#submitBtn');
            const originalText = submitBtn.html();
            submitBtn.html('<i class="fas fa-spinner fa-spin"></i> Authenticating...');
            submitBtn.prop('disabled', true);
            
            // Show loading overlay
            $('#loadingOverlay').fadeIn(300);
            
            // Let the form submit normally to Laravel
        });
        
        // Check if there are any Laravel validation errors
        @if($errors->any())
            showError('{{ $errors->first() }}');
            shakeElement($('#admin-login'));
        @endif
        
        // Helper functions
        function showError(message) {
            $('#errorMessage').text(message);
            $('#errorAlert').show();
        }
        
        function showSuccess(message) {
            $('#successMessage').text(message);
            $('#successAlert').show();
        }
        
        function isValidEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }
        
        function shakeElement(element) {
            element.addClass('shake');
            setTimeout(() => {
                element.removeClass('shake');
            }, 500);
        }
        
        // Add focus effects
        $('.form-control').on('focus', function() {
            $(this).siblings('.input-icon').css('color', 'var(--primary)');
            $(this).closest('.input-container').addClass('focused');
        }).on('blur', function() {
            $(this).siblings('.input-icon').css('color', 'var(--text-gray)');
            $(this).closest('.input-container').removeClass('focused');
        });
        
        // Enter key support
        $(document).on('keypress', function(e) {
            if (e.which === 13) {
                $('#admin-login').submit();
            }
        });
        
        // Add CSS for shake animation
        $('<style>').text(`
            .shake {
                animation: shake 0.5s ease-in-out;
            }
            @keyframes shake {
                0%, 100% { transform: translateX(0); }
                25% { transform: translateX(-10px); }
                75% { transform: translateX(10px); }
            }
        `).appendTo('head');
    });
</script>

</body>
</html>