<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{env('APP_NAME')}} - Gift Code</title>

    <link rel="icon" href="/smartlab/smartlab.png" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Montserrat', sans-serif;
            user-select: none;
        }

        body {
            background: var(--primary-bg);
            color: var(--text-primary);
            min-height: 100vh;
            padding-bottom: 80px;
            font-size: 14px;
        }

        main {
            max-width: 500px;
            margin: auto;
            padding: 20px;
        }

        .navbar {
            background: var(--secondary-bg);
            color: var(--accent-gold);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
            padding: 16px 20px;
            position: sticky;
            top: 0;
            z-index: 100;
            display: flex;
            justify-content: center;
            align-items: center;
            border-bottom: 1px solid var(--border-color);
        }

        .navbar .left a {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--accent-gold);
            font-size: 16px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 12px;
            border-radius: 8px;
            transition: var(--transition);
        }

        .navbar .left a:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: translateY(-50%) scale(1.05);
        }

        .navbar .center {
            font-weight: 700;
            font-size: 18px;
            color: var(--accent-gold);
        }

        .gift-container {
            padding: 20px 0;
            text-align: center;
        }

        .gift-card {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 25px;
            padding: 30px 25px;
            transition: var(--transition);
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }

        .gift-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .gift-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(255, 215, 0, 0.2);
            border-color: var(--accent-gold);
        }

        .gift-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
            background: rgba(255, 215, 0, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 3px solid var(--accent-gold);
            transition: var(--transition);
        }

        .gift-card:hover .gift-icon {
            transform: scale(1.1);
            background: rgba(255, 215, 0, 0.2);
        }

        .gift-icon i {
            font-size: 36px;
            color: var(--accent-gold);
        }

        .gift-title {
            font-size: 24px;
            color: var(--accent-gold);
            font-weight: 700;
            margin-bottom: 15px;
        }

        .gift-description {
            font-size: 16px;
            color: var(--text-secondary);
            line-height: 1.6;
            margin-bottom: 25px;
        }

        .claim-btn {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            border: none;
            padding: 15px 30px;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
            width: 100%;
            max-width: 250px;
        }

        .claim-btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }

        /* Modal Styles */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            z-index: 2000;
            display: none;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            width: 90%;
            max-width: 400px;
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }

        .modal-content::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .modal-header {
            padding: 25px 25px 15px;
            text-align: center;
            border-bottom: 1px solid var(--border-color);
        }

        .modal-header h3 {
            color: var(--accent-gold);
            font-size: 20px;
            font-weight: 700;
        }

        .modal-body {
            padding: 25px;
        }

        .input-group {
            margin-bottom: 20px;
        }

        .input-group input {
            width: 100%;
            padding: 15px 18px;
            background: var(--secondary-bg);
            border: 1px solid var(--border-color);
            border-radius: 10px;
            color: var(--text-primary);
            font-size: 16px;
            transition: var(--transition);
        }

        .input-group input:focus {
            outline: none;
            border-color: var(--accent-gold);
            box-shadow: 0 0 0 2px rgba(255, 215, 0, 0.2);
        }

        .input-group input::placeholder {
            color: var(--text-muted);
        }

        .modal-footer {
            padding: 20px 25px 25px;
            display: flex;
            gap: 15px;
            border-top: 1px solid var(--border-color);
        }

        .modal-btn {
            flex: 1;
            padding: 12px 20px;
            border: none;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }

        .modal-btn.cancel {
            background: var(--secondary-bg);
            color: var(--text-secondary);
            border: 1px solid var(--border-color);
        }

        .modal-btn.cancel:hover {
            background: rgba(255, 255, 255, 0.1);
            color: var(--text-primary);
        }

        .modal-btn.confirm {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }

        .modal-btn.confirm:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }

        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            display: flex;
            justify-content: space-around;
            background: var(--secondary-bg);
            border-top: 1px solid var(--border-color);
            padding: 12px 0;
            z-index: 1000;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
            max-width: 500px;
            margin: 0 auto;
            left: 0;
            right: 0;
        }

        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: var(--text-muted);
            font-size: 12px;
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }

        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }

        .nav-item .icon-wrap {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 5px;
            transition: var(--transition);
            background: var(--card-bg);
        }

        .nav-item i {
            font-size: 18px;
        }

        .nav-item.active .icon-wrap {
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark));
            color: #000;
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }

        .nav-item.active span {
            color: var(--accent-gold);
            font-weight: 600;
        }

        /* Loading Animation */
        .loading {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: var(--card-bg);
            padding: 30px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            z-index: 3000;
            display: none;
            border: 1px solid var(--border-color);
        }

        .loading::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .loading-spinner {
            width: 40px;
            height: 40px;
            border: 3px solid var(--border-color);
            border-top: 3px solid var(--accent-gold);
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 15px;
        }

        .loading-text {
            color: var(--text-secondary);
            font-size: 14px;
            text-align: center;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @media (max-width: 480px) {
            main {
                padding: 15px;
            }
            
            .gift-card {
                padding: 25px 20px;
            }
            
            .gift-title {
                font-size: 22px;
            }
            
            .modal-content {
                width: 95%;
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }
    </style>
</head>

<body>
    <div class="navbar">
        <div class="left"><a href="{{ url()->previous() }}"><i class="fas fa-arrow-left"></i> Back</a></div>
        <div class="center"><i class="fas fa-gift me-2"></i>Gift Code</div>
    </div>

    <main>
        <div class="gift-container">
            <div class="gift-card">
                <div class="gift-icon">
                    <i class="fas fa-gift"></i>
                </div>
                <h1 class="gift-title">Claim Your Gift</h1>
                <p class="gift-description">
                    Enter your redemption code to claim amazing rewards and bonuses. 
                    Don't miss this opportunity to get exclusive benefits!
                </p>
                <button class="claim-btn" onclick="openGift()">
                    <i class="fas fa-gift me-2"></i>Claim Gift Code
                </button>
            </div>

            <div class="gift-card">
                <div class="gift-icon">
                    <i class="fas fa-star"></i>
                </div>
                <h2 class="gift-title">How It Works</h2>
                <p class="gift-description">
                    1. Get a redemption code from promotions or events<br>
                    2. Click "Claim Gift Code" button<br>
                    3. Enter your code in the popup<br>
                    4. Receive your rewards instantly!
                </p>
            </div>
        </div>
    </main>

    <!-- Gift Modal -->
    <div class="modal-overlay" id="giftModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="fas fa-gift me-2"></i>Redemption Code</h3>
            </div>
            <div class="modal-body">
                <div class="input-group">
                    <input type="text" placeholder="Please enter redemption code" name="code" id="giftCode">
                </div>
            </div>
            <div class="modal-footer">
                <button class="modal-btn cancel" onclick="closeGift()">Cancel</button>
                <button class="modal-btn confirm" onclick="submitBonus()">Confirm</button>
            </div>
        </div>
    </div>

    <!-- Loading Overlay -->
    <div class="loading" id="loadingOverlay">
        <div class="loading-spinner"></div>
        <div class="loading-text">Processing...</div>
    </div>

    <!-- Bottom Navigation -->
    <footer class="bottom-nav">
        <a href="{{ url('home') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-home"></i></div>
            <span>হোম</span>
        </a>
        <a href="{{ url('ordered') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-store"></i></div>
            <span>খনন</span>
        </a>
        <a href="{{ url('my-team') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
            <span>আমন্ত্রণ</span>
        </a>
        <a href="{{ url('profile') }}" class="nav-item active">
            <div class="icon-wrap"><i class="fas fa-user"></i></div>
            <span>আমার</span>
        </a>
    </footer>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        function openGift() {
            document.getElementById('giftModal').style.display = 'flex';
        }

        function closeGift() {
            document.getElementById('giftModal').style.display = 'none';
            document.getElementById('giftCode').value = '';
        }

        function loading() {
            document.getElementById('loadingOverlay').style.display = 'block';
        }

        function hideLoading() {
            document.getElementById('loadingOverlay').style.display = 'none';
        }

        function submitBonus() {
            var code = document.getElementById('giftCode').value;
            
            if (!code) {
                alert('Please enter a redemption code.');
                return;
            }

            closeGift();
            loading();

            // Play success sound
            var audio = new Audio("/public/win.mp3");
            
            $.ajax({
                url: "/submit-bonus-confirm/" + code,
                type: 'GET',
                dataType: 'json',
                success: function(res) {
                    if (res.status == true) {
                        audio.play();
                        alert(res.message + " Amount of winnings: " + res.amount);
                    } else {
                        alert(res.message);
                    }
                    document.getElementById('giftCode').value = '';
                    hideLoading();
                },
                error: function() {
                    alert('Failed to submit the code. Please try again.');
                    hideLoading();
                }
            });
        }

        // Add interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.gift-card');
            
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-5px)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            const buttons = document.querySelectorAll('.claim-btn, .modal-btn');
            buttons.forEach(btn => {
                btn.addEventListener('click', function() {
                    this.style.transform = 'scale(0.95)';
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 150);
                });
            });

            // Close modal when clicking outside
            document.getElementById('giftModal').addEventListener('click', function(e) {
                if (e.target === this) {
                    closeGift();
                }
            });

            // Auto-check payments and commission
            $.ajax({
                url: '/onepay-payment-checker',
                type: 'GET',
                dataType: 'json',
                success: function(res) {
                    console.log('Payment check completed');
                }
            });

            $.ajax({
                url: '/commission-interest',
                type: 'GET',
                dataType: 'json',
                success: function(res) {
                    console.log('Commission calculation completed');
                }
            });
        });
    </script>
</body>
</html>