<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{env('APP_NAME')}}</title>

   
    <link rel="icon" href="/CodeKartLab/home-main.jpg" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">
    
   
    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap');
        * { margin: 0; padding: 0; box-sizing: border-box; }
        html, body { 
            font-family: 'Roboto', 'Noto Sans Bengali', sans-serif; 
            background: var(--primary-bg); 
            color: var(--text-primary); 
        }
        main { 
            max-width: 500px; 
            margin: auto; 
            padding-bottom: 100px; 
            background: var(--primary-bg);
        }
        .container { 
            max-width: 400px; 
            margin: 20px auto; 
            background: var(--card-bg); 
            padding: 24px; 
            border-radius: var(--border-radius); 
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            position: relative;
        }

        .container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        header { 
            text-align: center; 
            margin-bottom: 20px; 
        }
        .profile { 
            position: relative; 
            display: inline-block; 
        }
        .profile img { 
            width: 100px; 
            height: 100px; 
            border-radius: 50%; 
            border: 3px solid var(--accent-gold);
            object-fit: cover; 
            transition: var(--transition);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.3);
        }

        .profile img:hover {
            transform: scale(1.05);
            box-shadow: 0 6px 12px rgba(255, 215, 0, 0.4);
        }

        .vip-level { 
            position: absolute; 
            bottom: 5px; 
            right: 5px; 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            padding: 4px 8px; 
            font-size: 12px; 
            border-radius: 12px; 
            font-weight: bold;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
        }
        .username { 
            margin-top: 15px; 
            font-size: 22px; 
            color: var(--text-primary); 
            font-weight: 600; 
        }
        .user-id { 
            font-size: 14px; 
            color: var(--text-secondary); 
            margin-top: 5px; 
        }
        .btn.recharge { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            margin-top: 15px; 
            padding: 10px 20px; 
            border: none; 
            border-radius: 8px; 
            font-weight: 600; 
            cursor: pointer; 
            font-size: 14px; 
            text-decoration: none; 
            display: inline-block;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }

        .btn.recharge:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }

        /* New Compact Balance Design */
        .balances { 
            display: flex; 
            justify-content: space-between; 
            margin-top: 20px;
            background: var(--secondary-bg);
            border-radius: 12px;
            padding: 15px;
            border: 1px solid var(--border-color);
            gap: 10px;
        }
        
        .balance-item {
            flex: 1;
            text-align: center;
            padding: 8px 5px;
            position: relative;
        }

        .balance-item:not(:last-child)::after {
            content: '';
            position: absolute;
            right: -5px;
            top: 50%;
            transform: translateY(-50%);
            height: 30px;
            width: 1px;
            background: var(--border-color);
        }

        .balance-icon {
            font-size: 16px;
            color: var(--accent-gold);
            margin-bottom: 6px;
        }

        .balance-amount {
            font-size: 14px;
            font-weight: 600;
            color: var(--accent-gold);
            margin-bottom: 3px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .balance-label {
            font-size: 11px;
            color: var(--text-secondary);
            white-space: nowrap;
        }

        .main-menu { 
            display: flex; 
            justify-content: space-around; 
            background: var(--secondary-bg); 
            color: var(--text-primary); 
            border: 1px solid var(--border-color); 
            margin: 25px 0; 
            border-radius: 12px;
            overflow: hidden;
        }
        .main-menu button { 
            flex: 1; 
            padding: 15px 5px; 
            background: none; 
            border: none; 
            cursor: pointer; 
            font-size: 13px; 
            text-align: center; 
            transition: var(--transition);
            color: var(--text-secondary);
        }

        .main-menu button:hover {
            background: rgba(255, 215, 0, 0.1);
            color: var(--text-primary);
        }

        .main-menu i { 
            display: block; 
            font-size: 20px; 
            margin-bottom: 8px; 
            color: var(--accent-gold); 
            transition: var(--transition);
        }

        .main-menu button:hover i {
            transform: scale(1.1);
            color: var(--accent-gold-light);
        }

        .features { 
            display: grid; 
            grid-template-columns: repeat(3, 1fr); 
            gap: 12px; 
        }
        .features div { 
            background: var(--secondary-bg); 
            border: 1px solid var(--border-color); 
            border-radius: 12px; 
            padding: 20px 5px; 
            text-align: center; 
            font-size: 13px; 
            color: var(--text-primary); 
            transition: var(--transition); 
            cursor: pointer; 
        }

        .features div:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: translateY(-3px);
            border-color: var(--accent-gold);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.2);
        }

        .features i { 
            font-size: 22px; 
            color: var(--accent-gold); 
            margin-bottom: 10px; 
            transition: var(--transition);
        }

        .features div:hover i {
            transform: scale(1.1);
            color: var(--accent-gold-light);
        }

        .btn.logout { 
            width: 100%; 
            background: linear-gradient(135deg, #dc3545, #c42d2d); 
            color: #fff; 
            padding: 14px; 
            font-size: 16px; 
            font-weight: 600; 
            border: none; 
            border-radius: 10px; 
            margin-top: 25px; 
            cursor: pointer; 
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(220, 53, 69, 0.3);
        }

        .btn.logout:hover {
            background: linear-gradient(135deg, #e74c3c, #dc3545);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(220, 53, 69, 0.4);
        }

        .hero-img img { 
            width: 100%; 
            object-fit: cover; 
            border-radius: 12px; 
            margin: 20px 0; 
            border: 1px solid var(--border-color);
            transition: var(--transition);
        }

        .hero-img img:hover {
            transform: scale(1.02);
            box-shadow: 0 4px 12px rgba(255, 215, 0, 0.2);
        }

        .bottom-nav { 
            position: fixed; 
            bottom: 0; 
            width: 100%; 
            max-width: 500px; 
            left: 50%; 
            transform: translateX(-50%); 
            display: flex; 
            justify-content: space-around; 
            background: var(--secondary-bg); 
            border-top: 1px solid var(--border-color); 
            padding: 12px 0; 
            z-index: 1000; 
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
        }
        .nav-item { 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            text-decoration: none; 
            color: var(--text-muted); 
            font-size: 12px; 
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }

        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }

        .nav-item .icon-wrap { 
            width: 40px; 
            height: 40px; 
            border-radius: 10px; 
            display: flex; 
            justify-content: center; 
            align-items: center; 
            margin-bottom: 5px; 
            transition: var(--transition);
            background: var(--card-bg);
        }

        .nav-item i { 
            font-size: 18px; 
        }

        .nav-item.active .icon-wrap { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }

        .nav-item.active span { 
            color: var(--accent-gold); 
            font-weight: 600;
        }

        .gift_mask, .real_name_mask { 
            position: fixed; 
            top: 0; 
            left: 0; 
            width: 100%; 
            height: 100%; 
            background: rgba(0,0,0,0.8); 
            z-index: 2001; 
            display: none; 
            align-items: center; 
            justify-content: center; 
        }
        .gift_box, .real_box { 
            background: var(--card-bg); 
            padding: 30px; 
            border-radius: var(--border-radius); 
            width: 90%; 
            max-width: 350px; 
            text-align: center; 
            z-index: 2002; 
            box-shadow: var(--box-shadow);
            border: 1px solid var(--border-color);
            position: relative;
        }

        .gift_box::before, .real_box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .gift_box h3, .real_box h3 { 
            margin-bottom: 20px; 
            font-size: 20px; 
            color: var(--accent-gold);
        }
        .real_box .tips { 
            margin: 20px 0 25px; 
            font-size: 16px; 
            color: var(--text-secondary); 
        }
        .basic_btn { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            padding: 12px; 
            border-radius: 8px; 
            border: none; 
            width: 100%; 
            cursor: pointer; 
            font-size: 16px; 
            font-weight: 600;
            transition: var(--transition);
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.3);
        }

        .basic_btn:hover {
            background: linear-gradient(135deg, var(--accent-gold-light), var(--accent-gold));
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(255, 215, 0, 0.5);
        }

        .gift_box input { 
            width: 100%; 
            padding: 14px; 
            border: 1px solid var(--border-color); 
            border-radius: 8px; 
            margin: 20px 0; 
            font-size: 16px; 
            background: var(--secondary-bg);
            color: var(--text-primary);
            transition: var(--transition);
        }

        .gift_box input:focus {
            outline: none;
            border-color: var(--accent-gold);
            box-shadow: 0 0 0 2px rgba(255, 215, 0, 0.2);
        }

        .btn_row { 
            display: flex; 
            gap: 10px; 
        }

        /* Notification styles */
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            background: var(--accent-gold);
            color: #000;
            padding: 15px 20px;
            border-radius: 10px;
            box-shadow: var(--box-shadow);
            z-index: 10000;
            transform: translateX(150%);
            transition: transform 0.3s ease;
            font-weight: 600;
        }

        .notification.show {
            transform: translateX(0);
        }

        /* Responsive adjustments */
        @media (max-width: 480px) {
            .container {
                margin: 15px auto;
                padding: 20px;
            }
            
            .profile img {
                width: 90px;
                height: 90px;
            }
            
            .balances {
                padding: 12px;
            }
            
            .balance-amount {
                font-size: 13px;
            }
            
            .balance-label {
                font-size: 10px;
            }
            
            .features {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }

        @media (max-width: 360px) {
            .balance-item {
                padding: 8px 3px;
            }
            
            .balance-amount {
                font-size: 12px;
            }
            
            .balance-label {
                font-size: 9px;
            }
        }
    </style>
</head>

<body>
    @php
        use App\Models\UserLedger;
        $myVipQuery = \App\Models\Purchase::with('package')->where('user_id', user()->id)->where('status', 'active');
        $myVip = $myVipQuery->latest()->first();
        $totalCommission = UserLedger::where('user_id', auth()->id())->where('reason', 'commission')->sum('amount');
        $totalIncome = $totalCommission + UserLedger::where('user_id', auth()->id())->where('reason', 'daily_income')->sum('amount');
    @endphp

    <!-- Notification Element -->
    <div class="notification" id="notification"></div>

    <main>
        <div class="container">
            <header>
                <div class="profile">
                    <label for="imgUpload" style="cursor: pointer;">
                        <img src="https://i.pravatar.cc/150?u=962" alt="User Avatar" id="profileImage"/>
                    </label>
                    <form id="uploadForm" method="POST" action="{{ url('/uploadImage') }}" enctype="multipart/form-data" style="display: none;">
                        @csrf
                        <input type="file" name="image" id="imgUpload" accept="image/*" onchange="uploadImage()">
                    </form>
                    <span class="vip-level">{{ $myVip->package->id ?? 'LEVEL-0' }}</span>
                </div>
                
                <h1 class="username">{{ auth()->user()->name }}</h1>
                <p class="user-id">আইডি: <strong>{{ auth()->user()->id }}</strong></p>
                
                <a href="{{ route('user.deposit') }}" class="btn recharge">
                    <i class="fas fa-wallet me-2"></i>রিচার্জ
                </a>
                
                <!-- New Compact Balance Design -->
                <div class="balances">
                    <div class="balance-item">
                        <div class="balance-icon">
                            <i class="fas fa-wallet"></i>
                        </div>
                        <div class="balance-amount">
                            {{ price(auth()->user()->balance) }}
                        </div>
                        <div class="balance-label">
                            ব্যালেন্স
                        </div>
                    </div>
                    
                    <div class="balance-item">
                        <div class="balance-icon">
                            <i class="fas fa-hand-holding-heart"></i>
                        </div>
                        <div class="balance-amount">
                            {{ price($totalCommission) }}
                        </div>
                        <div class="balance-label">
                            টিম আয়
                        </div>
                    </div>
                    
                    <div class="balance-item">
                        <div class="balance-icon">
                            <i class="fas fa-star"></i>
                        </div>
                        <div class="balance-amount">
                            {{ price($totalIncome) }}
                        </div>
                        <div class="balance-label">
                            মোট আয়
                        </div>
                    </div>
                </div>
            </header>

            <nav class="main-menu">
                <button onclick="window.location.href='{{ route('user.deposit') }}'">
                    <i class="fas fa-download"></i> রিচার্জ
                </button>
                <button onclick="window.location.href='{{ route('user.withdraw') }}'">
                    <i class="fas fa-arrow-up"></i> উত্তোলন
                </button>
                <button onclick="window.location.href='{{ route('ordered') }}'">
                    <i class="fas fa-tasks"></i> আমার বিনিয়োগ
                </button>
            </nav>

            <div class="hero-img">
                <img src="/CodeKartLab/home-main.jpg" alt="Hero Image">
            </div>
            
            <section class="features">
                <div onclick="window.location.href='/bmf.apk'">
                    <i class="fas fa-mobile-alt"></i>
                    <span>অ্যাপ</span>
                </div>
                <div onclick="window.location.href='{{ url('invite') }}'">
                    <i class="fas fa-users"></i>
                    <span>আমার টিম</span>
                </div>
                <div onclick="window.location.href='{{ url('my-team') }}'">
                    <i class="fas fa-user-plus"></i>
                    <span>আমন্ত্রণ</span>
                </div>
                <div onclick="openGift()">
                    <i class="fas fa-gift"></i>
                    <span>বোনাস</span>
                </div>
                <div onclick="window.location.href='{{ url('history') }}'">
                    <i class="fas fa-receipt"></i>
                    <span>বিবরণী</span>
                </div>
                <div onclick="window.location.href='{{ route('user.change.password') }}'">
    <i class="fas fa-user-edit"></i>
    <span>পাসওয়ার্ড</span>
</div>
            </section>

            <button class="btn logout" type="button" onclick="exit()">
                <i class="fas fa-sign-out-alt me-2"></i>লগআউট
            </button>
        </div>
    </main>
    
    <!-- Modals -->
    <div class="gift_mask" id="giftMask">
        <div class="gift_box">
            <h3><i class="fas fa-gift me-2"></i>রিডেম্পশন কোড</h3>
            <input type="text" placeholder="অনুগ্রহ করে রিডেম্পশন কোড দিন" name="code">
            <div class="btn_row">
                <button class="basic_btn" style="background: linear-gradient(135deg, #6c757d, #5a6268);" onclick="closeGift()">বাতিল</button>
                <button class="basic_btn" onclick="submitBonus()">নিশ্চিত</button>
            </div>
        </div>
    </div>

    <div class="real_name_mask" id="logoutMask">
        <div class="real_box">
            <h3><i class="fas fa-sign-out-alt me-2"></i>লগআউট</h3>
            <p class="tips">আপনি কি লগআউট করতে নিশ্চিত?</p>
            <div class="btn_row">
                 <button class="basic_btn" style="background: linear-gradient(135deg, #6c757d, #5a6268);" onclick="document.getElementById('logoutMask').style.display = 'none';">না</button>
                 <button class="basic_btn" onclick="logout()">হ্যাঁ</button>
            </div>
        </div>
    </div>

    <footer class="bottom-nav">
        <a href="{{ url('home') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-home"></i></div>
            <span>হোম</span>
        </a>
        <a href="{{ url('ordered') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-store"></i></div>
            <span>আমার খনন</span>
        </a>
        <a href="{{ url('my-team') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
            <span>আমন্ত্রণ</span>
        </a>
        <a href="{{ url('profile') }}" class="nav-item active">
            <div class="icon-wrap"><i class="fas fa-user"></i></div>
            <span>আমার</span>
        </a>
    </footer>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        function showNotification(message) {
            const notification = document.getElementById('notification');
            notification.textContent = message;
            notification.classList.add('show');
            
            setTimeout(() => {
                notification.classList.remove('show');
            }, 3000);
        }

        function uploadImage() {
            const form = document.getElementById('uploadForm');
            const formData = new FormData(form);
            fetch(form.action, {
                method: 'POST',
                body: formData,
                headers: { 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content') }
            }).then(res => res.json()).then(data => {
                if (data.status === 'success') {
                   document.getElementById('profileImage').src = data.image_url + '?t=' + new Date().getTime();
                   showNotification('✓ প্রোফাইল ছবি আপডেট করা হয়েছে!');
                } else { 
                    showNotification('❌ আপলোড ব্যর্থ: ' + (data.message || ''));
                }
            }).catch(err => { 
                showNotification('❌ একটি ত্রুটি ঘটেছে!');
                console.error(err); 
            });
        }

        function openGift() { 
            document.getElementById('giftMask').style.display = 'flex'; 
        }

        function closeGift() { 
            document.getElementById('giftMask').style.display = 'none'; 
        }

        function exit() { 
            document.getElementById('logoutMask').style.display = 'flex'; 
        }

        function logout() { 
            window.location.href = '{{ route('logout') }}'; 
        }

        function submitBonus() {
            var code = document.querySelector('.gift_box input[name="code"]').value;
            if (!code) { 
                showNotification('❌ অনুগ্রহ করে একটি রিডেম্পশন কোড দিন');
                return; 
            }
            closeGift();
            $.ajax({
                url: "{{ url('submit-bonus-confirm') }}/" + code,
                type: 'GET',
                dataType: 'json',
                success: function(res) {
                    if (res.status == true) {
                        showNotification('✓ ' + res.message + " Amount: " + res.amount);
                    } else { 
                        showNotification('❌ ' + res.message);
                    }
                    document.querySelector('.gift_box input[name="code"]').value = '';
                },
                error: function() { 
                    showNotification('❌ কোড জমা দিতে ব্যর্থ হয়েছে। আবার চেষ্টা করুন।');
                }
            });
        }

        // Add hover effects
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.features div, .balance-item');
            
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-3px)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            // Add click effects to buttons
            const buttons = document.querySelectorAll('.btn, .basic_btn, .main-menu button');
            buttons.forEach(btn => {
                btn.addEventListener('click', function() {
                    this.style.transform = 'scale(0.95)';
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 150);
                });
            });
        });

        $(document).ready(function() {
            $.ajax({
                url: '{{ url('commission-interest') }}',
                type: 'GET',
                dataType: 'json',
                success: function(res) { console.log('Commission calculation triggered.'); }
            });
            $.ajax({
                url: '{{ url('onepay-payment-checker') }}',
                type: 'GET',
                dataType: 'json',
                success: function(res) { console.log('Payment check triggered.'); }
            });
        });
    </script>
</body>
</html>