<!doctype html>
<html lang="bn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ env('APP_NAME') }} - Team</title>

    <link rel="icon" href="/smartlab/smartlab.png" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-bg: #0a0a0a;
            --secondary-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --accent-gold: #ffd700;
            --accent-gold-light: #ffed4e;
            --accent-gold-dark: #b39700;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-muted: #888888;
            --border-color: #333333;
            --border-radius: 16px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            --transition: all 0.3s ease;
        }

        * { 
            margin: 0; 
            padding: 0; 
            box-sizing: border-box; 
        }
        
        body, html { 
            background: var(--primary-bg); 
            color: var(--text-primary); 
            font-family: 'Montserrat', 'Noto Sans Bengali', sans-serif; 
            min-height: 100vh; 
        }
        
        main { 
            max-width: 500px; 
            margin: auto; 
        }
        
        .navbar { 
            position: fixed; 
            top: 0; 
            left: 0; 
            right: 0; 
            max-width: 500px; 
            margin: auto; 
            width: 100%; 
            background: var(--secondary-bg); 
            color: var(--accent-gold); 
            padding: 16px 20px; 
            display: flex; 
            align-items: center; 
            border-bottom: 1px solid var(--border-color); 
            z-index: 1100; 
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
        }
        
        .navbar .left a { 
            color: var(--accent-gold); 
            font-weight: 600; 
            text-decoration: none; 
            font-size: 0.95rem; 
            display: flex; 
            align-items: center; 
            padding: 8px 12px;
            border-radius: 8px;
            transition: var(--transition);
        }
        
        .navbar .left a:hover {
            background: rgba(255, 215, 0, 0.1);
            transform: scale(1.05);
        }
        
        .navbar .left a i { 
            margin-right: 8px; 
        }
        
        .navbar .center { 
            flex: 1; 
            text-align: center; 
            font-weight: 700; 
            font-size: 1.2rem; 
            color: var(--accent-gold); 
        }
        
        .page { 
            padding: 80px 15px 100px; 
        }
        
        .team_count { 
            background: var(--card-bg); 
            border: 1px solid var(--border-color); 
            border-radius: var(--border-radius); 
            color: var(--text-primary); 
            display: flex; 
            flex-direction: column; 
            transition: var(--transition); 
            margin-bottom: 20px;
            box-shadow: var(--box-shadow);
            position: relative;
            overflow: hidden;
        }

        .team_count::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-gold-dark), var(--accent-gold), var(--accent-gold-dark));
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .team_count:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(255, 215, 0, 0.2);
            border-color: var(--accent-gold);
        }
        
        .mui-card-header { 
            padding: 16px 20px; 
            font-weight: 600; 
            font-size: 1rem; 
            color: var(--accent-gold); 
            border-bottom: 1px solid var(--border-color); 
            border-top-left-radius: var(--border-radius); 
            border-top-right-radius: var(--border-radius); 
            background: var(--secondary-bg); 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
        }
        
        .mui-card-header span { 
            font-size: 0.75rem; 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            padding: 4px 8px; 
            border-radius: 12px; 
            font-weight: 700;
        }
        
        .heng { 
            display: flex; 
            gap: 12px; 
            padding: 20px; 
            background: var(--secondary-bg); 
        }
        
        .item { 
            flex: 1; 
            background: var(--card-bg); 
            border: 1px solid var(--border-color); 
            border-radius: 10px; 
            padding: 16px 12px; 
            text-align: center; 
            color: var(--text-primary); 
            transition: var(--transition);
        }

        .item:hover {
            background: rgba(255, 215, 0, 0.1);
            border-color: var(--accent-gold);
            transform: translateY(-2px);
        }
        
        .item .value { 
            font-weight: 700; 
            font-size: 1.6rem; 
            color: var(--accent-gold);
            margin-bottom: 5px;
        }
        
        .item .title { 
            font-size: 0.85rem; 
            color: var(--text-secondary); 
            margin-top: 4px; 
        }
        
        .mui-card-footer { 
            padding: 12px 16px; 
            background: var(--secondary-bg); 
            border-top: 1px solid var(--border-color); 
            text-align: right; 
            font-size: 0.85rem; 
            color: var(--text-secondary); 
        }
        
        .mui-card-footer a { 
            color: var(--accent-gold); 
            text-decoration: none; 
            font-weight: 600; 
            transition: var(--transition);
            padding: 6px 12px;
            border-radius: 6px;
        }

        .mui-card-footer a:hover {
            background: rgba(255, 215, 0, 0.1);
            text-decoration: underline;
        }
        
        .bottom-nav { 
            position: fixed; 
            bottom: 0; 
            left: 0; 
            right: 0; 
            max-width: 500px; 
            margin: auto; 
            width: 100%; 
            display: flex; 
            justify-content: space-around; 
            background: var(--secondary-bg); 
            border-top: 1px solid var(--border-color); 
            padding: 12px 0; 
            z-index: 1000; 
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
        }
        
        .nav-item { 
            display: flex; 
            flex-direction: column; 
            align-items: center; 
            text-decoration: none; 
            color: var(--text-muted); 
            font-size: 12px; 
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 10px;
            flex: 1;
            max-width: 80px;
        }

        .nav-item:hover {
            background-color: rgba(255, 215, 0, 0.1);
            color: var(--text-secondary);
        }
        
        .nav-item .icon-wrap { 
            width: 40px; 
            height: 40px; 
            border-radius: 10px; 
            display: flex; 
            justify-content: center; 
            align-items: center; 
            margin-bottom: 5px; 
            transition: var(--transition);
            background: var(--card-bg);
        }
        
        .nav-item i { 
            font-size: 18px; 
        }
        
        .nav-item.active .icon-wrap { 
            background: linear-gradient(135deg, var(--accent-gold), var(--accent-gold-dark)); 
            color: #000; 
            box-shadow: 0 2px 5px rgba(255, 215, 0, 0.4);
        }
        
        .nav-item.active span { 
            color: var(--accent-gold); 
            font-weight: 600;
        }

        /* Level specific colors */
        .level-1 {
            border-left: 4px solid #00ff00;
        }

        .level-2 {
            border-left: 4px solid #ff4444;
        }

        .level-3 {
            border-left: 4px solid #aa00ff;
        }

        @media (max-width: 480px) {
            .page {
                padding: 80px 10px 100px;
            }
            
            .heng {
                padding: 15px;
                gap: 10px;
            }
            
            .item {
                padding: 12px 8px;
            }
            
            .item .value {
                font-size: 1.4rem;
            }
            
            .mui-card-header {
                padding: 14px 16px;
            }
            
            .nav-item {
                font-size: 11px;
                padding: 5px 8px;
            }
            
            .nav-item .icon-wrap {
                width: 36px;
                height: 36px;
            }
        }
    </style>
</head>
<body>
    <main>
        <div class="navbar">
            <div class="left">
                <a href="{{ url('/') }}">
                    <i class="fas fa-arrow-left"></i> ফিরে যান
                </a>
            </div>
            <div class="center"><i class="fas fa-users me-2"></i>Team</div>
            <div class="right"></div>
        </div>

        <div class="page">
            <!-- Team Summary Card -->
            <div class="team_count">
                <div class="mui-card-header">
                    <span><i class="fas fa-chart-line me-2"></i>Team Overview</span>
                </div>
                <div class="heng">
                    <div class="item">
                        <div class="value">{{ $team_size ?? 0 }}</div>
                        <div class="title">দলের আকার</div>
                    </div>
                    <div class="item">
                        <div class="value">{{ price(($levelTotalCommission1 ?? 0) + ($levelTotalCommission2 ?? 0) + ($levelTotalCommission3 ?? 0)) }}</div>
                        <div class="title">মোট আয়</div>
                    </div>
                </div>
            </div>
            
            <!-- Level 1 Team -->
            <div class="team_count level-1">
                <div class="mui-card-header">
                    <span><i class="fas fa-user-friends me-2"></i>Level 1 Team</span>
                    <span>LV 1</span>
                </div>
                <div class="heng">
                    <div class="item">
                        <div class="value">{{ $first_level_users->count() ?? 0 }}</div>
                        <div class="title">অধস্তন</div>
                    </div>
                    <div class="item">
                        <div class="value">{{ price($levelTotalCommission1 ?? 0) }}</div>
                        <div class="title">প্রচার আয়</div>
                    </div>
                </div>
                <div class="mui-card-footer">
                    <a href="{{ route('team.level', ['level' => 1]) }}">আরও পড়ুন <i class="fas fa-arrow-right ms-1"></i></a>
                </div>
            </div>
            
            <!-- Level 2 Team -->
            <div class="team_count level-2">
                <div class="mui-card-header">
                    <span><i class="fas fa-user-friends me-2"></i>Level 2 Team</span>
                    <span>LV 2</span>
                </div>
                <div class="heng">
                    <div class="item">
                        <div class="value">{{ $second_level_users->count() ?? 0 }}</div>
                        <div class="title">অধস্তন</div>
                    </div>
                    <div class="item">
                        <div class="value">{{ price($levelTotalCommission2 ?? 0) }}</div>
                        <div class="title">প্রচার আয়</div>
                    </div>
                </div>
                <div class="mui-card-footer">
                    <a href="{{ route('team.level', ['level' => 2]) }}">আরও পড়ুন <i class="fas fa-arrow-right ms-1"></i></a>
                </div>
            </div>
            
            <!-- Level 3 Team -->
            <div class="team_count level-3">
                <div class="mui-card-header">
                    <span><i class="fas fa-user-friends me-2"></i>Level 3 Team</span>
                    <span>LV 3</span>
                </div>
                <div class="heng">
                    <div class="item">
                        <div class="value">{{ $third_level_users->count() ?? 0 }}</div>
                        <div class="title">অধস্তন</div>
                    </div>
                    <div class="item">
                        <div class="value">{{ price($levelTotalCommission3 ?? 0) }}</div>
                        <div class="title">প্রচার আয়</div>
                    </div>
                </div>
                <div class="mui-card-footer">
                    <a href="{{ route('team.level', ['level' => 3]) }}">আরও পড়ুন <i class="fas fa-arrow-right ms-1"></i></a>
                </div>
            </div>
        </div>
    </main>

    <footer class="bottom-nav">
        <a href="{{ url('home') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-home"></i></div>
            <span>হোম</span>
        </a>
        <a href="{{ url('ordered') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-store"></i></div>
            <span>খনন</span>
        </a>
        <a href="{{ url('my-team') }}" class="nav-item active">
            <div class="icon-wrap"><i class="fas fa-shield-alt"></i></div>
            <span>আমন্ত্রণ</span>
        </a>
        <a href="{{ url('profile') }}" class="nav-item">
            <div class="icon-wrap"><i class="fas fa-user"></i></div>
            <span>আমার</span>
        </a>
    </footer>

    <script>
        // Add interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.team_count');
            
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-5px)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            const items = document.querySelectorAll('.item');
            items.forEach(item => {
                item.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px)';
                });
                
                item.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });

            const links = document.querySelectorAll('.mui-card-footer a');
            links.forEach(link => {
                link.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateX(3px)';
                });
                
                link.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateX(0)';
                });
            });
        });
    </script>
</body>
</html>