<!DOCTYPE html>
<html lang="bn" class="">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    
    <title>GoPay - Payment CheckOut</title>

    {{-- প্রথম ফাইলের CSS কোড এখানে যুক্ত করা হয়েছে --}}
    <style>
        .order-info-div[data-v-a086747e] {
            margin: -130px 20px 15px;
            background: url() no-repeat;
            background-size: cover;
            border-radius: 12px;
        }

        html {
            -webkit-tap-highlight-color: transparent
        }

        body {
            margin: 0;
            font-family: -apple-system, BlinkMacSystemFont, Helvetica Neue, Helvetica, Segoe UI, Arial, Roboto, PingFang SC, miui, Hiragino Sans GB, Microsoft Yahei, sans-serif
        }

        a {
            text-decoration: none
        }

        button,
        input,
        textarea {
            color: inherit;
            font: inherit
        }

        [class*=van-]:focus,
        a:focus,
        button:focus,
        input:focus,
        textarea:focus {
            outline: none
        }

        ol,
        ul {
            margin: 0;
            padding: 0;
            list-style: none
        }

        .background-div[data-v-a086747e] {
            background: #ffbf5963;
            height: 160px;
            border-radius: 0 0 10% 10%
        }

        .title[data-v-a086747e] {
            display: flex;
            align-items: center
        }

        .title img[data-v-a086747e] {
            width: 26px;
            margin-right: 3px
        }

        .title span[data-v-a086747e] {
            font-weight: 700;
            font-size: 18px;
            margin-left: 6px
        }

        .order-info-div[data-v-a086747e] {
            margin: -130px 20px 15px;
            background: url(/smartlab/home.png) no-repeat;
            background-size: cover;
            border-radius: 12px
        }

        .order-info-div .order-info-inner-div[data-v-a086747e] {
            padding: 15px
        }

        .order-info-div .order-title-div[data-v-a086747e] {
            margin-top: 30px;
            font-size: 16px;
            display: flex;
            flex-direction: column;
            margin-bottom: 20px;
            font-weight: 700
        }

        .order-info-div .order-title-div span[data-v-a086747e] {
            margin: auto
        }

        .order-info-div .amount-div[data-v-a086747e] {
            margin: 0 5px;
            padding: 20px 0 10px;
            text-align: center;
            font-weight: 700;
            font-size: 32px
        }

        .bankcard-div[data-v-a086747e] {
            margin: 20px
        }

        .bankcard-div .bankcard-title[data-v-a086747e] {
            font-size: 14px
        }

        .bankcard-div .bankcard-input[data-v-a086747e] {
            margin-top: 15px;
            border: 1px solid silver;
            border-radius: 8px;
            padding: 0
        }

        .bankcard-div .bankcard-input.input-warn[data-v-a086747e] {
            border: 1px solid #ee0a2475
        }

        .bankcard-div .bankcard-input[data-v-a086747e] input {
            border-radius: 5px;
            background: #fff;
            display: block;
            width: calc(100% - 10px);
            outline: 0;
            height: 40px;
            font-size: 14px;
            padding-left: 10px
        }

        .bank-list-div[data-v-a086747e] {
            margin: 15px 20px 20px
        }

        .bank-list-div .bank-list-title[data-v-a086747e] {
            font-size: 14px
        }

        .bank-list-div .list-content[data-v-a086747e] {
            display: flex;
            justify-content: space-around;
            flex-wrap: wrap; /* নতুন পেমেন্ট মেথড নিচে আসার জন্য */
        }

        .bank-list-div .list-content.specify[data-v-a086747e] {
            justify-content: left
        }

        .bank-list-div .list-content .bank-item[data-v-a086747e] {
            border: 1px solid #cecece;
            border-radius: 6px;
            padding: 10px;
            display: flex;
            width: 45%;
            margin: 10px 5px; /* মার্জিন অ্যাডজাস্ট করা হয়েছে */
            justify-content: space-between;
            align-items: center;
            cursor: pointer; /* কার্সার যুক্ত করা হয়েছে */
        }

        .bank-list-div .list-content .bank-item.selected .select-icon[data-v-a086747e],
        .bank-list-div .list-content .bank-item.selected[data-v-a086747e] {
            border: 1px solid #2752e7
        }

        .bank-list-div .list-content .bank-item.selected .select-icon .select-inner-icon[data-v-a086747e] {
            background-color: #2752e7
        }

        .bank-list-div .list-content .bank-item .select-icon[data-v-a086747e] {
            border: 1px solid #d9d9d9;
            width: 13px;
            height: 13px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center
        }

        .bank-list-div .list-content .bank-item .select-icon .select-inner-icon[data-v-a086747e] {
            width: 8px;
            height: 8px;
            border-radius: 50%
        }

        .bank-list-div .list-content .bank-item .select-label[data-v-a086747e] {
            display: flex;
            align-items: center
        }

        .bank-list-div .list-content .bank-item .select-label .bank-logo[data-v-a086747e] {
            height: 30px;
            width: 32px;
            margin-right: 5px
        }

        .btn-div[data-v-a086747e] {
            margin: 20px
        }

        .btn-div .pay-btn[data-v-a086747e] {
            background-color: #2752e7;
            color: #fff;
            border-radius: 6px
        }

        .tips-div[data-v-a086747e] {
            margin: 0 20px 20px;
            color: #bfbfbf;
            font-size: 14px
        }

        .tips-div .tips[data-v-a086747e] {
            display: block;
            margin-bottom: 5px
        }

        .tips-div .important[data-v-a086747e] {
            color: #ffaf2a
        }

        .van-field__control {
            display: block;
            box-sizing: border-box;
            width: 100%;
            min-width: 0;
            margin: 0;
            padding: 0;
            color: #323233;
            line-height: inherit;
            text-align: left;
            background-color: transparent;
            border: 0;
            resize: none;
        }

        .van-button {
            position: relative;
            display: inline-block;
            box-sizing: border-box;
            height: 44px;
            margin: 0;
            padding: 0;
            font-size: 16px;
            line-height: 1.2;
            text-align: center;
            border-radius: 2px;
            cursor: pointer;
            -webkit-transition: opacity .2s;
            transition: opacity .2s;
            -webkit-appearance: none;
        }

        .van-button--block {
            display: block;
            width: 100%;
        }
        
    </style>
</head>

<body cz-shortcut-listen="true">
    <div id="app">
        <div data-v-a086747e="" class="repay-div main">
            <div data-v-a086747e="" class="background-div"></div>
            <div data-v-a086747e="" class="order-info-div">
                <div data-v-a086747e="" class="order-info-inner-div">
                    <div data-v-a086747e="" class="title">
                        <img data-v-a086747e="" src="/smartlab/logo.png" class="log">
                        <span data-v-a086747e="" class="name">GoPay</span>
                    </div>
                    
                    <div data-v-a086747e="" class="order-title-div"><span data-v-a086747e="">অর্ডার আইডি: {{ $order_id ?? 'GPGO17412852356592778' }}</span></div>
                    
                    <div data-v-a086747e="" class="amount-div"><span data-v-a086747e="">{{ $amount }} টাকা</span></div>
                </div>
            </div>
            <div data-v-a086747e="" class="bankcard-div">
                <span data-v-a086747e="" class="bankcard-title">আপনার অ্যাকাউন্ট</span>
                <div data-v-a086747e="" class="bankcard-input van-cell van-field">
                    <div class="van-cell__value van-cell__value--alone van-field__value">
                        <div class="van-field__body">
                            <input type="number" placeholder="e.g 01XXXXXXXXX" name="number" class="van-field__control">
                        </div>
                    </div>
                </div>
            </div>
            
            }
            <div data-v-a086747e="" class="bank-list-div">
                <div data-v-a086747e="" class="bank-list-title">পেমেন্ট চ্যানেল</div>
                <div data-v-a086747e="" class="list-content">
                    @php
                        // 데이터베이스에서 결제 방법을 가져옵니다.
                        $paymentMethods = \App\Models\PaymentMethod::get();
                    @endphp

                    @foreach($paymentMethods as $key => $element)
                    <div data-v-a086747e="" class="bank-item @if($key == 0) selected @endif" onclick="bankItem(this, '{{$element->name}}')">
                        <div data-v-a086747e="" class="select-icon">
                            <div data-v-a086747e="" class="select-inner-icon"></div>
                        </div>
                        <div data-v-a086747e="" class="select-label">
                            <img data-v-a086747e="" src="{{asset($element->photo)}}" class="bank-logo">
                            <span data-v-a086747e="">{{$element->name}}</span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <div data-v-a086747e="" class="btn-div">
                
                <button data-v-a086747e="" onclick="goPayConfirmLink()" class="pay-btn van-button">
                    <div data-v-a086747e="" class="van-button__content">
                        <span data-v-a086747e="" class="van-button__text"> পেমেন্ট যান </span>
                    </div>
                </button>
            </div>
            
            <div data-v-a086747e="" class="tips-div">
                <span data-v-a086747e="" class="tips">1. একটি ব্যাঙ্ক অ্যাকাউন্ট পেতে একটি ব্যাঙ্কের নাম চয়ন করুন, এবং তথ্য অনুযায়ী সংশ্লিষ্ট ব্যাঙ্কের নাম ও ব্যাঙ্ক অ্যাকাউন্টে টাকা ট্রান্সফার করতে হবে</span>
                <span data-v-a086747e="" class="tips">2. একই ফোন নম্বর একাধিক ব্যাঙ্ক অ্যাকাউন্টের সাথে লিঙ্ক করা যেতে পারে। আপনার পছন্দের অন্য কোনো ব্যাঙ্ক অ্যাকাউন্টে টাকা ট্রান্সফার করবেন না</span>
                <span data-v-a086747e="" class="tips"><span data-v-a086747e="" class="important">*গুরুত্বপূর্ণ অনুস্মারক:&nbsp;</span>একই ফোন নম্বর সহ অন্য ব্যাঙ্কে টাকা স্থানান্তর করা হলে, টাকা আপনার অ্যাকাউন্টে জমা নাও হতে পারে।</span>
            </div>
        </div>
    </div>
    
    
    <input type="hidden" name="amount" value="{{ $amount }}">
   
    <input type="hidden" name="channel" value="{{ $paymentMethods->first()->name ?? '' }}">
    
   
    <script>
       
        function message(text) {
            alert(text);
        }

    
        function bankItem(_this, bank) {
            var els = document.querySelectorAll('.bank-item');
            for (let i = 0; i < els.length; i++) {
                if (els[i].classList.contains('selected')) {
                    els[i].classList.remove('selected');
                }
            }
            _this.classList.add('selected');

           
            document.querySelector('input[name="channel"]').value = bank;
        }

        
        function goPayConfirmLink() {
            var number = document.querySelector('input[name="number"]').value;
            var amount = document.querySelector('input[name="amount"]').value;
            var channel = document.querySelector('input[name="channel"]').value;

            
            if (!number.length) {
                return message('আপনার অ্যাকাউন্ট নম্বর লিখুন');
            }
            if (number.length < 11) {
                return message('অনুগ্রহ করে একটি সঠিক অ্যাকাউন্ট নম্বর লিখুন');
            }
            if (!amount.length) {
                return message('আপনার রিচার্জ পরিমাণ লিখুন');
            }
            if (!channel.length) {
                return message('একটি পেমেন্ট চ্যানেল নির্বাচন করুন');
            }

            
            let baseUrl = '{{ url("user/payment") }}';
            let redirectUrl = `${baseUrl}/${amount}/${channel}?sender=${number}`;
            
            window.location.href = redirectUrl;
        }
    </script>
</body>
</html>