<!DOCTYPE html>
<html lang="bn">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>GoPay - Payment Confirmation</title>

    
    <style>
        .detail-div .background-div[data-v-19b76dce] {
            height: 170px;
            border-radius: 0 0 10% 10%;
            background: url(smartlab/home.png) no-repeat;
            background-size: cover;
        }

        .detail-div[data-v-19b76dce] {
            background: #f2f2f2;
            overflow: auto
        }

        .detail-div .background-div[data-v-19b76dce] {
            height: 170px;
            border-radius: 0 0 10% 10%;
            background: url(smartlab/home.png) no-repeat;
            background-size: cover
        }

        .detail-div .header[data-v-19b76dce] {
            background: #419eff;
            color: #fff;
            height: 45px;
            font-size: 18px;
            text-align: center;
            line-height: 45px
        }

        .detail-div .detail-content-div[data-v-19b76dce] {
            margin: -165px 0 20px
        }

        .detail-div .detail-content-div .title[data-v-19b76dce] {
            margin: 20px auto 20px;
            background: #fff;
            width: 90px;
            height: 90px;
            border-radius: 100%;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center
        }

        .detail-div .detail-content-div .title .log[data-v-19b76dce] {
            width: 35px;
            display: block;
            margin-bottom: 10px
        }

        .detail-div .detail-content-div .title .name[data-v-19b76dce] {
            font-size: 16px;
            text-align: center;
            display: block;
            font-weight: 700
        }

        .detail-div .tips-div[data-v-19b76dce] {
            background: #fff;
            margin: 15px;
            border-radius: 8px;
            padding: 20px
        }

        .detail-div .tips-div .tips-step[data-v-19b76dce] {
            color: #2752e7;
            font-size: 16px;
            font-weight: 700
        }

        .detail-div .tips-div .tips-desc[data-v-19b76dce] {
            color: #222;
            font-size: 14px;
            font-weight: 700;
            padding: 8px 0
        }

        .detail-div .tips-div .tips-content[data-v-19b76dce] {
            padding: 10px 0
        }

        .detail-div .bankcard-div[data-v-19b76dce] {
            display: flex;
            justify-content: space-between;
            border-top: 1px solid silver;
            padding: 10px 0
        }

        .detail-div .bankcard-div .bankcard-desc[data-v-19b76dce] {
            font-size: 12px;
            color: #666;
            height: 30px;
            line-height: 30px
        }

        .detail-div .bankcard-div .bankcard-value[data-v-19b76dce] {
            display: flex;
            align-items: center
        }

        .detail-div .bankcard-div .bankcard-value i[data-v-19b76dce] {
            margin-left: 8px
        }

        .detail-div .amount-div[data-v-19b76dce] {
            display: flex;
            justify-content: space-between;
            padding: 10px 0 0;
            font-weight: 700
        }

        .detail-div .amount-div .amount-desc[data-v-19b76dce] {
            font-size: 16px
        }

        .detail-div .amount-div .amount-value[data-v-19b76dce] {
            font-size: 20px;
            color: #ffaf2a
        }

        .detail-div .red[data-v-19b76dce] {
            color: red
        }

        .detail-div .strong[data-v-19b76dce] {
            font-weight: 700
        }

        .detail-div .tips-value[data-v-19b76dce] {
            font-size: 12px
        }

        .detail-div .warn[data-v-19b76dce] {
            background-color: #fee;
            padding: 10px;
            display: flex;
            border-radius: 5px
        }

        .detail-div .required[data-v-19b76dce] {
            color: red;
            font-size: 16px;
            margin-right: 5px
        }

        .detail-div .tips-image-div[data-v-19b76dce] {
            display: flex;
            flex-direction: row;
            margin-bottom: 10px
        }

        .detail-div .tips-image[data-v-19b76dce] {
            flex: 1;
            width: 50%;
            padding: 5px;
        }

        .detail-div .tips-image img[data-v-19b76dce] {
            width: 100%
        }

        .detail-div .input-div[data-v-19b76dce] {
            border-top: 1px solid silver;
            margin-top: 15px;
        }

        .detail-div .input-div .input[data-v-19b76dce] {
            border: 1px solid silver;
            border-radius: 8px;
            padding: 0;
            margin: 15px 0 10px; 
            width: 100%;
        }

        .detail-div .input-div .input.input-warn[data-v-19b76dce] {
            border: 1px solid #ee0a2475
        }

        .detail-div .input-div .input[data-v-19b76dce] input {
            border-radius: 5px;
            background: #fff;
            display: block;
            width: calc(100% - 10px);
            outline: 0;
            height: 40px;
            font-size: 14px;
            padding-left: 10px;
            border: none;
        }

        .detail-div .btn-div[data-v-19b76dce] {
            display: flex
        }

        .detail-div .btn-div .pay-btn[data-v-19b76dce] {
            background: #5370e5;
            margin: 20px 10px;
            border-radius: 15px;
            color: #fff;
            flex: 1;
            border: none;
        }

        .detail-div .btn-div .cancel-btn[data-v-19b76dce] {
            background: #888;
        }

        .van-button {
            position: relative;
            display: inline-block;
            box-sizing: border-box;
            height: 44px;
            padding: 0;
            font-size: 16px;
            line-height: 1.2;
            text-align: center;
            border-radius: 2px;
            cursor: pointer;
        }
    </style>
</head>

<body>
    <div id="app">
        
        <form action="{{route('depositSubmit')}}" method="post">
            @csrf
            <div data-v-19b76dce="" class="detail-div main">
                <div data-v-19b76dce="" class="background-div"></div>
                <div data-v-19b76dce="" class="detail-content-div">
                    <div data-v-19b76dce="" class="title">
                        <img data-v-19b76dce="" src="{{asset($payment_method->photo)}}" class="log">
                        <span data-v-19b76dce="" class="name">{{ $payment_method->name }}</span>
                    </div>

                    
                    <div data-v-19b76dce="" class="tips-div">
                        <div data-v-19b76dce="" class="tips-step">ধাপ ১.</div>
                        <div data-v-19b76dce="" class="tips-desc">নিচের অ্যাকাউন্টে টাকা পাঠান</div>
                        <div data-v-19b76dce="" class="tips-content">
                            <div data-v-19b76dce="" class="bankcard-div">
                                <span data-v-19b76dce="" class="bankcard-desc">রিসিভার নম্বর</span>
                                <span data-v-19b76dce="" class="bankcard-value">
                                    <span>{{ $payment_method->address }}</span>
                                    <span onclick="copyLink('{{ $payment_method->address }}')" style="cursor: pointer; margin-left: 8px;">
                                        <img style="width: 20px;" src="https://img.icons8.com/fluency-systems-regular/50/copy.png" alt="Copy">
                                    </span>
                                </span>
                            </div>
                            <div data-v-19b76dce="" class="amount-div">
                                <span data-v-19b76dce="" class="amount-desc">পরিশোধিত অর্থ</span>
                                <span data-v-19b76dce="" class="amount-value">{{ $amount }} টাকা</span>
                            </div>
                        </div>
                    </div>

                    
                    <div data-v-19b76dce="" class="tips-div">
                        <div data-v-19b76dce="" class="tips-step">ধাপ ২.</div>
                        <div data-v-19b76dce="" class="tips-desc">
                            আপনার {{ $payment_method->name }} অ্যাপ থেকে টাকা পাঠানোর পর ট্রানজেকশন আইডি (TrxID) কপি করুন।
                        </div>
                    </div>

                    
                    <div data-v-19b76dce="" class="tips-div">
                        <div data-v-19b76dce="" class="tips-step">ধাপ ৩.</div>
                        <div data-v-19b76dce="" class="tips-desc">আপনার পেমেন্টের তথ্য জমা দিন</div>

                        <div data-v-19b76dce="" class="input-div">
                           
                             <div data-v-19b76dce="" class="input">
                                <input type="text" name="acc_acount" placeholder="আপনার অ্যাকাউন্ট নম্বর দিন" required>
                            </div>
                            
                           
                            <div data-v-19b76dce="" class="input">
                                <input type="text" name="transaction_id" placeholder="আপনার পেমেন্ট ট্রানজেকশন আইডি" required>
                            </div>
                        </div>
                    </div>

                   
                    <div data-v-19b76dce="" class="btn-div">
                        
                        <button data-v-19b76dce="" onclick="window.history.back()" type="button" class="pay-btn van-button cancel-btn">
                            <span data-v-19b76dce="" class="van-button__text"> বাতিল করুন </span>
                        </button>
                        
                       
                        <button data-v-19b76dce="" type="button" onclick="goPaymentForm()" class="pay-btn van-button">
                             <span data-v-19b76dce="" class="van-button__text"> পেমেন্ট নিশ্চিত করুন </span>
                        </button>
                    </div>
                </div>
            </div>

           
            <input type="hidden" name="payment_method" value="{{$payment_method->name}}">
            <input type="hidden" name="amount" value="{{$amount}}">

        </form>
    </div>

    <script>
        
        function message(text) {
            alert(text);
        }
        
        
        function copyLink(text) {
            const input = document.createElement("input");
            document.body.append(input);
            input.style.opacity = 0;
            input.value = text.trim();
            input.select();
            document.execCommand("copy");
            input.remove();
            message('নম্বর সফলভাবে কপি করা হয়েছে');
        }

        
        function goPaymentForm() {
            
            let acc_acount = document.querySelector('input[name="acc_acount"]').value;
            let transaction_id = document.querySelector('input[name="transaction_id"]').value;

           
            if (acc_acount.trim() === '') {
                message('অনুগ্রহ করে আপনার অ্যাকাউন্ট নম্বর দিন।');
                return; 
            }

            if (transaction_id.trim() === '') {
                message('অনুগ্রহ করে আপনার পেমেন্ট ট্রানজেকশন আইডি দিন।');
                return; 
            }

            
            document.querySelector('form').submit();
        }
    </script>
</body>

</html>